/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import lombok.Generated;

public class EruptApiModel {
    private Status status;
    private PromptWay promptWay;
    private String message;
    private Object data;

    public EruptApiModel(Status status, String message, Object data, PromptWay promptWay) {
        this.status = status;
        this.message = message;
        this.data = data;
        this.promptWay = promptWay;
    }

    public EruptApiModel(Status status, String message, PromptWay promptWay) {
        this.status = status;
        this.message = message;
        this.promptWay = promptWay;
    }

    public static EruptApiModel successApi() {
        return new EruptApiModel(Status.SUCCESS, null, null, PromptWay.MESSAGE);
    }

    public static EruptApiModel successApi(String message, Object data) {
        return new EruptApiModel(Status.SUCCESS, message, data, PromptWay.MESSAGE);
    }

    public static EruptApiModel successApi(Object data) {
        return new EruptApiModel(Status.SUCCESS, null, data, PromptWay.MESSAGE);
    }

    public static EruptApiModel errorApi(String message) {
        return new EruptApiModel(Status.ERROR, message, null, PromptWay.DIALOG);
    }

    public static EruptApiModel errorApi(Exception e) {
        return new EruptApiModel(Status.ERROR, e.getMessage(), null, PromptWay.DIALOG);
    }

    public static EruptApiModel errorMessageApi(String message) {
        return new EruptApiModel(Status.ERROR, message, null, PromptWay.MESSAGE);
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public PromptWay getPromptWay() {
        return this.promptWay;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setPromptWay(PromptWay promptWay) {
        this.promptWay = promptWay;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setData(Object data) {
        this.data = data;
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        INFO,
        WARNING;

    }

    public static enum PromptWay {
        DIALOG,
        MESSAGE,
        NOTIFY,
        NONE;

    }
}

