/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.view;

import java.io.Serializable;
import lombok.Generated;
import xyz.erupt.core.view.EruptApiModel;

public class R<T>
implements Serializable {
    private T data;
    private String message;
    private boolean success;
    private EruptApiModel.Status status;
    private EruptApiModel.PromptWay promptWay = EruptApiModel.PromptWay.MESSAGE;

    public static <T> R<T> ok(T data) {
        R<T> r = new R<T>();
        r.setSuccess(true);
        r.setData(data);
        r.setPromptWay(EruptApiModel.PromptWay.NONE);
        r.setStatus(EruptApiModel.Status.SUCCESS);
        return r;
    }

    public static <T> R<T> ok() {
        R<T> r = new R<T>();
        r.setSuccess(true);
        r.setStatus(EruptApiModel.Status.SUCCESS);
        return r;
    }

    public static <T> R<T> error(String message) {
        R<T> r = new R<T>();
        r.setSuccess(false);
        r.setMessage(message);
        r.setStatus(EruptApiModel.Status.ERROR);
        return r;
    }

    public static <T> R<T> errorNotIntercept(String message, T data) {
        R<T> r = new R<T>();
        r.setSuccess(false);
        r.setMessage(message);
        r.setPromptWay(EruptApiModel.PromptWay.NONE);
        r.setStatus(EruptApiModel.Status.ERROR);
        r.setData(data);
        return r;
    }

    public static <T> R<T> errorNotIntercept(T data) {
        return R.errorNotIntercept(null, data);
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public EruptApiModel.Status getStatus() {
        return this.status;
    }

    @Generated
    public EruptApiModel.PromptWay getPromptWay() {
        return this.promptWay;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setStatus(EruptApiModel.Status status) {
        this.status = status;
    }

    @Generated
    public void setPromptWay(EruptApiModel.PromptWay promptWay) {
        this.promptWay = promptWay;
    }

    public static enum PromptWay {
        DIALOG,
        MESSAGE,
        NOTIFY,
        NONE;

    }

    public static enum Status {
        SUCCESS,
        ERROR,
        INFO,
        WARNING;

    }
}

