/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.transaction.annotation.Transactional;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.linq.lambda.LambdaInfo;
import xyz.erupt.linq.lambda.LambdaSee;
import xyz.erupt.linq.lambda.SFunction;

public class EruptLambdaQuery<T> {
    private final QuerySchema querySchema = new QuerySchema();
    private final EntityManager entityManager;
    private final Class<T> eruptClass;

    public EruptLambdaQuery(EntityManager entityManager, Class<T> eruptClass) {
        this.entityManager = entityManager;
        this.eruptClass = eruptClass;
    }

    public <E, R> EruptLambdaQuery<T> with(SFunction<E, R> field) {
        this.querySchema.getWith().add(LambdaSee.field(field));
        return this;
    }

    public EruptLambdaQuery<T> with() {
        this.querySchema.getWith().clear();
        return this;
    }

    public <E, R> EruptLambdaQuery<T> isNull(SFunction<E, R> field) {
        this.querySchema.getWheres().add(this.geneField(field) + " is null");
        return this;
    }

    public <E, R> EruptLambdaQuery<T> isNull(boolean condition, SFunction<E, R> field) {
        if (condition) {
            return this.isNull(field);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> isNotNull(SFunction<E, R> field) {
        this.querySchema.getWheres().add(this.geneField(field) + " is not null");
        return this;
    }

    public <E, R> EruptLambdaQuery<T> isNotNull(boolean condition, SFunction<E, R> field) {
        if (condition) {
            return this.isNotNull(field);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> eq(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " = :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> eq(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.eq(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> ne(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " <> :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> ne(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.ne(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> gt(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " > :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> gt(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.gt(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> lt(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " < :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> lt(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.lt(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> ge(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " >= :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> ge(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.ge(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> le(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " <= :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> le(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.le(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> between(SFunction<E, R> field, Object val1, Object val2) {
        String l = this.genePlaceholder();
        String r = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " between :" + l + " and :" + r);
        this.querySchema.getParams().put(l, val1);
        this.querySchema.getParams().put(r, val2);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> between(boolean condition, SFunction<E, R> field, Object val1, Object val2) {
        if (condition) {
            return this.between(field, val1, val2);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> notBetween(SFunction<E, R> field, Object val1, Object val2) {
        String l = this.genePlaceholder();
        String r = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " not between :" + l + " and :" + r);
        this.querySchema.getParams().put(l, val1);
        this.querySchema.getParams().put(r, val2);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> notBetween(boolean condition, SFunction<E, R> field, Object val1, Object val2) {
        if (condition) {
            return this.notBetween(field, val1, val2);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> in(SFunction<E, R> field, Collection<?> val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " in (:" + placeholder + ")");
        this.querySchema.getParams().put(placeholder, new ArrayList(val));
        return this;
    }

    public <E, R> EruptLambdaQuery<T> in(boolean condition, SFunction<E, R> field, Collection<?> val) {
        if (condition) {
            return this.in(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> in(SFunction<E, R> field, Object ... val) {
        return this.in(field, Arrays.stream(val).collect(Collectors.toList()));
    }

    public <E, R> EruptLambdaQuery<T> in(boolean condition, SFunction<E, R> field, Object ... val) {
        if (condition) {
            return this.in(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> notIn(SFunction<E, R> field, Collection<?> val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " not in (:" + placeholder + ")");
        this.querySchema.getParams().put(placeholder, new ArrayList(val));
        return this;
    }

    public <E, R> EruptLambdaQuery<T> notIn(boolean condition, SFunction<E, R> field, Collection<?> val) {
        if (condition) {
            return this.notIn(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> notIn(SFunction<E, R> field, Object ... val) {
        return this.notIn(field, Arrays.stream(val).collect(Collectors.toList()));
    }

    public <E, R> EruptLambdaQuery<T> notIn(boolean condition, SFunction<E, R> field, Object ... val) {
        if (condition) {
            return this.notIn(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> like(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " like :" + placeholder);
        this.querySchema.getParams().put(placeholder, "%" + val + "%");
        return this;
    }

    public <E, R> EruptLambdaQuery<T> like(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.like(field, val);
        }
        return this;
    }

    public <E, R> EruptLambdaQuery<T> likeValue(SFunction<E, R> field, Object val) {
        String placeholder = this.genePlaceholder();
        this.querySchema.getWheres().add(this.geneField(field) + " like :" + placeholder);
        this.querySchema.getParams().put(placeholder, val);
        return this;
    }

    public <E, R> EruptLambdaQuery<T> likeValue(boolean condition, SFunction<E, R> field, Object val) {
        if (condition) {
            return this.likeValue(field, val);
        }
        return this;
    }

    public EruptLambdaQuery<T> addCondition(String condition) {
        this.querySchema.getWheres().add(condition);
        return this;
    }

    public EruptLambdaQuery<T> addCondition(String condition, Map<String, Object> params) {
        this.querySchema.getWheres().add(condition);
        Optional.ofNullable(params).ifPresent(it -> this.querySchema.getParams().putAll(params));
        return this;
    }

    public EruptLambdaQuery<T> addParam(String key, Object val) {
        this.querySchema.getParams().put(key, val);
        return this;
    }

    public <E> EruptLambdaQuery<T> orderBy(SFunction<E, ?> field) {
        this.querySchema.getOrders().add(this.geneField(field) + " asc");
        return this;
    }

    public <E> EruptLambdaQuery<T> orderBy(boolean condition, SFunction<E, ?> field) {
        if (condition) {
            return this.orderBy(field);
        }
        return this;
    }

    public <E> EruptLambdaQuery<T> orderByAsc(SFunction<E, ?> field) {
        return this.orderBy(field);
    }

    public <E> EruptLambdaQuery<T> orderByAsc(boolean condition, SFunction<E, ?> field) {
        return this.orderBy(condition, field);
    }

    public <E> EruptLambdaQuery<T> orderByDesc(SFunction<E, ?> field) {
        this.querySchema.getOrders().add(this.geneField(field) + " desc");
        return this;
    }

    public EruptLambdaQuery<T> orderByDesc(boolean condition, SFunction<T, ?> field) {
        if (condition) {
            return this.orderByDesc(field);
        }
        return this;
    }

    public EruptLambdaQuery<T> limit(Integer limit) {
        this.querySchema.setLimit(limit);
        return this;
    }

    public EruptLambdaQuery<T> offset(Integer offset) {
        this.querySchema.setOffset(offset);
        return this;
    }

    public EruptLambdaQuery<T> distinct() {
        this.querySchema.setDistinct(true);
        return this;
    }

    public T one() {
        try {
            return (T)this.geneQuery().getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<T> list() {
        return this.geneQuery().getResultList();
    }

    public final <S> S oneSelect(SFunction<T, S> field) {
        this.querySchema.columns.add(LambdaSee.field(field));
        try {
            return (S)this.geneQuery().getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public final <S> List<S> listSelect(SFunction<T, S> field) {
        this.querySchema.columns.add(LambdaSee.field(field));
        return this.geneQuery().getResultList();
    }

    @SafeVarargs
    public final <R> List<R> listSelect(Class<R> requiredType, SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.querySchema.columns.add(LambdaSee.field(field));
        }
        List objects = this.geneQuery().getResultList();
        return objects.stream().map(it -> this.objectToClazz(requiredType, (Object[])it, fields)).collect(Collectors.toList());
    }

    @SafeVarargs
    public final <R> R oneSelect(Class<R> requiredType, SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.querySchema.columns.add(LambdaSee.field(field));
        }
        try {
            return this.objectToClazz(requiredType, (Object[])this.geneQuery().getSingleResult(), fields);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Deprecated
    @SafeVarargs
    public final List<Object[]> listSelects(SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.querySchema.columns.add(LambdaSee.field(field));
        }
        return this.geneQuery().getResultList();
    }

    @Deprecated
    @SafeVarargs
    public final Object[] oneSelects(SFunction<T, ?> ... fields) {
        for (SFunction<T, ?> field : fields) {
            this.querySchema.columns.add(LambdaSee.field(field));
        }
        try {
            return (Object[])this.geneQuery().getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private <R> R objectToClazz(Class<R> clazz, Object[] objects, SFunction<?, ?> ... fields) {
        R r = clazz.newInstance();
        for (int i = 0; i < fields.length; ++i) {
            Field f = ReflectUtil.findClassField(clazz, (String)LambdaSee.field(fields[i]));
            f.setAccessible(true);
            f.set(r, objects[i]);
        }
        return r;
    }

    public Long count() {
        this.querySchema.columns.add("count(*)");
        return (Long)this.geneQuery().getSingleResult();
    }

    public <E> Long count(SFunction<E, ?> field) {
        this.querySchema.columns.add("count(" + this.geneField(field) + ")");
        return (Long)this.geneQuery().getSingleResult();
    }

    public <E> Object sum(SFunction<E, ?> field) {
        this.querySchema.columns.add("sum(" + this.geneField(field) + ")");
        return this.geneQuery().getSingleResult();
    }

    public <E> Double avg(SFunction<E, ?> field) {
        this.querySchema.columns.add("avg(" + this.geneField(field) + ")");
        return (Double)this.geneQuery().getSingleResult();
    }

    public <E> Object min(SFunction<E, ?> field) {
        this.querySchema.columns.add("min(" + this.geneField(field) + ")");
        return this.geneQuery().getSingleResult();
    }

    public <E> Object max(SFunction<E, ?> field) {
        this.querySchema.columns.add("max(" + this.geneField(field) + ")");
        return this.geneQuery().getSingleResult();
    }

    public int delete() {
        List<T> entities = this.list();
        for (T entity : entities) {
            this.entityManager.remove(entity);
        }
        return entities.size();
    }

    @Transactional
    public int deleteAndFlush() {
        int result = this.delete();
        this.entityManager.flush();
        return result;
    }

    private Query geneQuery() {
        StringBuilder select = new StringBuilder();
        if (!this.querySchema.columns.isEmpty()) {
            select.append("select ");
            if (this.querySchema.distinct) {
                select.append("distinct ");
            }
            this.querySchema.getColumns().forEach(it -> select.append((String)it).append(","));
            select.deleteCharAt(select.length() - 1);
        }
        StringBuilder expr = new StringBuilder(select + " from " + this.eruptClass.getSimpleName() + " as " + this.eruptClass.getSimpleName());
        if (!this.querySchema.getWheres().isEmpty()) {
            expr.append(" where ").append(String.join((CharSequence)" and ", this.querySchema.getWheres()));
        }
        if (!this.querySchema.getOrders().isEmpty()) {
            expr.append(" order by ").append(String.join((CharSequence)",", this.querySchema.getOrders()));
        }
        Query query = this.entityManager.createQuery(expr.toString());
        this.querySchema.getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        Optional.ofNullable(this.querySchema.getLimit()).ifPresent(arg_0 -> ((Query)query).setMaxResults(arg_0));
        Optional.ofNullable(this.querySchema.getOffset()).ifPresent(arg_0 -> ((Query)query).setFirstResult(arg_0));
        return query;
    }

    private String genePlaceholder() {
        return RandomStringUtils.randomAlphabetic((int)6);
    }

    private String geneField(SFunction<?, ?> field) {
        LambdaInfo lambdaInfo = LambdaSee.info(field);
        if (this.querySchema.with.isEmpty()) {
            return lambdaInfo.getClazz().getSimpleName() + "." + lambdaInfo.getField();
        }
        StringBuilder withs = new StringBuilder();
        this.querySchema.with.forEach(it -> withs.append((String)it).append("."));
        return withs + lambdaInfo.getField();
    }

    public static class QuerySchema {
        private List<String> with = new ArrayList<String>();
        private List<String> columns = new ArrayList<String>();
        private Map<String, Object> params = new HashMap<String, Object>();
        private List<String> wheres = new ArrayList<String>();
        private List<String> orders = new ArrayList<String>();
        private Integer limit;
        private Integer offset;
        private boolean distinct = false;

        public List<String> getWith() {
            return this.with;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public List<String> getWheres() {
            return this.wheres;
        }

        public List<String> getOrders() {
            return this.orders;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public Integer getOffset() {
            return this.offset;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public void setWith(List<String> with) {
            this.with = with;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setWheres(List<String> wheres) {
            this.wheres = wheres;
        }

        public void setOrders(List<String> orders) {
            this.orders = orders;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public void setOffset(Integer offset) {
            this.offset = offset;
        }

        public void setDistinct(boolean distinct) {
            this.distinct = distinct;
        }
    }
}

