/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.webscoket.channel;

import jakarta.websocket.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.webscoket.model.EruptWsSessionModel;

@Component
public class EruptChannelManager {
    private static final Map<String, EruptWsSessionModel> sessionMap = new ConcurrentHashMap<String, EruptWsSessionModel>();
    private static final Map<String, String> sessionTokenMap = new ConcurrentHashMap<String, String>();

    public static void register(String token, Session session) {
        sessionMap.computeIfAbsent(token, k -> new EruptWsSessionModel(((EruptUserService)EruptSpringUtil.getBean(EruptUserService.class)).getSimpleUserInfoByToken(token), new Vector<Session>()));
        sessionMap.get(token).getSessions().add(session);
        sessionTokenMap.put(session.getId(), token);
    }

    public static void close(Session session) {
        Optional.ofNullable(sessionTokenMap.remove(session.getId())).ifPresent(it -> {
            if (sessionMap.get(it).getSessions().size() <= 1) {
                sessionMap.remove(it);
            } else {
                sessionMap.get(it).getSessions().remove(session);
            }
        });
    }

    public static EruptWsSessionModel getSession(String token) {
        return sessionMap.get(token);
    }

    public static List<EruptWsSessionModel> getAllSession() {
        return new ArrayList<EruptWsSessionModel>(sessionMap.values());
    }
}

