/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration
@ConditionalOnClass(value={EnableIntegration.class})
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class IntegrationAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @EnableIntegrationMBeanExport(defaultDomain="${spring.jmx.default-domain:}", server="${spring.jmx.server:mbeanServer}")
    protected static class IntegrationJmxConfiguration {
        protected IntegrationJmxConfiguration() {
        }
    }

    @Configuration
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }
    }
}

