/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ProtectedResourceDetailsConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.config.annotation.web.configuration.OAuth2ClientConfiguration;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EnableOAuth2Client.class})
@Conditional(value={OAuth2ClientIdCondition.class})
public class OAuth2RestOperationsConfiguration {

    static class OAuth2ClientIdCondition
    extends SpringBootCondition {
        OAuth2ClientIdCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "security.oauth2.client.");
            String clientId = resolver.getProperty("client-id");
            ConditionMessage.Builder message = ConditionMessage.forCondition("OAuth Client ID", new Object[0]);
            if (StringUtils.hasLength((String)clientId)) {
                return ConditionOutcome.match(message.foundExactly("security.oauth2.client.client-id property"));
            }
            return ConditionOutcome.match(message.didNotFind("security.oauth2.client.client-id property").atAll());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OAuth2ClientConfiguration.class})
    @ConditionalOnWebApplication
    @Import(value={OAuth2ProtectedResourceDetailsConfiguration.class})
    protected static class RequestScopedConfiguration {
        protected RequestScopedConfiguration() {
        }

        @Bean
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public DefaultOAuth2ClientContext oauth2ClientContext() {
            OAuth2Authentication authentication;
            Object details;
            DefaultOAuth2ClientContext context = new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
            Authentication principal = SecurityContextHolder.getContext().getAuthentication();
            if (principal instanceof OAuth2Authentication && (details = (authentication = (OAuth2Authentication)principal).getDetails()) instanceof OAuth2AuthenticationDetails) {
                OAuth2AuthenticationDetails oauthsDetails = (OAuth2AuthenticationDetails)details;
                String token = oauthsDetails.getTokenValue();
                context.setAccessToken((OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            }
            return context;
        }
    }

    @Configuration
    @ConditionalOnBean(value={OAuth2ClientConfiguration.class})
    @ConditionalOnWebApplication
    @Import(value={OAuth2ProtectedResourceDetailsConfiguration.class})
    protected static class SessionScopedConfiguration {
        protected SessionScopedConfiguration() {
        }

        @Bean
        public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter, SecurityProperties security) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)filter);
            registration.setOrder(security.getFilterOrder() - 10);
            return registration;
        }

        @Configuration
        protected static class ClientContextConfiguration {
            @Resource
            @Qualifier(value="accessTokenRequest")
            protected AccessTokenRequest accessTokenRequest;

            protected ClientContextConfiguration() {
            }

            @Bean
            @Scope(value="session", proxyMode=ScopedProxyMode.INTERFACES)
            public DefaultOAuth2ClientContext oauth2ClientContext() {
                return new DefaultOAuth2ClientContext(this.accessTokenRequest);
            }
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    protected static class SingletonScopedConfiguration {
        protected SingletonScopedConfiguration() {
        }

        @Bean
        @ConfigurationProperties(value="security.oauth2.client")
        @Primary
        public ClientCredentialsResourceDetails oauth2RemoteResource() {
            ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
            return details;
        }

        @Bean
        public DefaultOAuth2ClientContext oauth2ClientContext() {
            return new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());
        }
    }
}

