/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@ConditionalOnClass(value={TransactionTemplate.class, PlatformTransactionManager.class})
@ConditionalOnSingleCandidate(value=PlatformTransactionManager.class)
@AutoConfigureAfter(value={JtaAutoConfiguration.class, HibernateJpaAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
public class TransactionAutoConfiguration {
    private final PlatformTransactionManager transactionManager;

    public TransactionAutoConfiguration(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public TransactionTemplate transactionTemplate() {
        return new TransactionTemplate(this.transactionManager);
    }
}

