/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.format;

import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.format.datetime.joda.JodaTimeFormatterRegistrar;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import org.springframework.format.number.money.CurrencyUnitFormatter;
import org.springframework.format.number.money.Jsr354NumberFormatAnnotationFormatterFactory;
import org.springframework.format.number.money.MonetaryAmountFormatter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class WebConversionService
extends DefaultFormattingConversionService {
    private static final boolean JSR_354_PRESENT = ClassUtils.isPresent((String)"javax.money.MonetaryAmount", (ClassLoader)WebConversionService.class.getClassLoader());
    private static final boolean JODA_TIME_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)WebConversionService.class.getClassLoader());
    private final String dateFormat;

    public WebConversionService(String dateFormat) {
        super(false);
        String string = this.dateFormat = StringUtils.hasText((String)dateFormat) ? dateFormat : null;
        if (this.dateFormat != null) {
            this.addFormatters();
        } else {
            WebConversionService.addDefaultFormatters((FormatterRegistry)this);
        }
    }

    private void addFormatters() {
        this.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new NumberFormatAnnotationFormatterFactory());
        if (JSR_354_PRESENT) {
            this.addFormatter((Formatter)new CurrencyUnitFormatter());
            this.addFormatter((Formatter)new MonetaryAmountFormatter());
            this.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new Jsr354NumberFormatAnnotationFormatterFactory());
        }
        this.registerJsr310();
        if (JODA_TIME_PRESENT) {
            this.registerJodaTime();
        }
        this.registerJavaDate();
    }

    private void registerJsr310() {
        DateTimeFormatterRegistrar dateTime = new DateTimeFormatterRegistrar();
        if (this.dateFormat != null) {
            dateTime.setDateFormatter(DateTimeFormatter.ofPattern(this.dateFormat).withResolverStyle(ResolverStyle.SMART));
        }
        dateTime.registerFormatters((FormatterRegistry)this);
    }

    private void registerJodaTime() {
        JodaTimeFormatterRegistrar jodaTime = new JodaTimeFormatterRegistrar();
        if (this.dateFormat != null) {
            jodaTime.setDateFormatter(new DateTimeFormatterBuilder().appendPattern(this.dateFormat).toFormatter());
        }
        jodaTime.registerFormatters((FormatterRegistry)this);
    }

    private void registerJavaDate() {
        DateFormatterRegistrar dateFormatterRegistrar = new DateFormatterRegistrar();
        if (this.dateFormat != null) {
            DateFormatter dateFormatter = new DateFormatter(this.dateFormat);
            dateFormatterRegistrar.setFormatter(dateFormatter);
        }
        dateFormatterRegistrar.registerFormatters((FormatterRegistry)this);
    }
}

