/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cache.autoconfigure;

import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.cache.autoconfigure.CacheConfigurations;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

class CacheCondition
extends SpringBootCondition {
    CacheCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Assert.isInstanceOf(AnnotationMetadata.class, (Object)metadata);
        return this.extracted(context, (AnnotationMetadata)metadata);
    }

    private ConditionOutcome extracted(ConditionContext context, AnnotationMetadata metadata) {
        String sourceClass = metadata.getClassName();
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Cache", (Object[])new Object[]{sourceClass});
        Environment environment = context.getEnvironment();
        try {
            BindResult specified = Binder.get((Environment)environment).bind("spring.cache.type", CacheType.class);
            if (!specified.isBound()) {
                return ConditionOutcome.match((ConditionMessage)message.because("automatic cache type"));
            }
            CacheType required = CacheConfigurations.getType(metadata.getClassName());
            if (specified.get() == required) {
                return ConditionOutcome.match((ConditionMessage)message.because(String.valueOf(specified.get()) + " cache type"));
            }
        }
        catch (BindException bindException) {
            // empty catch block
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.because("unknown cache type"));
    }
}

