/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import java.util.List;
import org.springframework.boot.data.redis.autoconfigure.RedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.RedisProperties;
import org.springframework.boot.data.redis.autoconfigure.RedisUrl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertiesRedisConnectionDetails
implements RedisConnectionDetails {
    private final RedisProperties properties;
    private final SslBundles sslBundles;

    PropertiesRedisConnectionDetails(RedisProperties properties, SslBundles sslBundles) {
        this.properties = properties;
        this.sslBundles = sslBundles;
    }

    @Override
    public String getUsername() {
        RedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? redisUrl.credentials().username() : this.properties.getUsername();
    }

    @Override
    public String getPassword() {
        RedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? redisUrl.credentials().password() : this.properties.getPassword();
    }

    @Override
    public RedisConnectionDetails.Standalone getStandalone() {
        RedisUrl redisUrl = this.getRedisUrl();
        return redisUrl != null ? RedisConnectionDetails.Standalone.of(redisUrl.uri().getHost(), redisUrl.uri().getPort(), redisUrl.database(), this.getSslBundle()) : RedisConnectionDetails.Standalone.of(this.properties.getHost(), this.properties.getPort(), this.properties.getDatabase(), this.getSslBundle());
    }

    private SslBundle getSslBundle() {
        if (!this.properties.getSsl().isEnabled()) {
            return null;
        }
        String bundleName = this.properties.getSsl().getBundle();
        if (StringUtils.hasLength((String)bundleName)) {
            Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
            return this.sslBundles.getBundle(bundleName);
        }
        return SslBundle.systemDefault();
    }

    @Override
    public RedisConnectionDetails.Sentinel getSentinel() {
        RedisProperties.Sentinel sentinel = this.properties.getSentinel();
        return sentinel != null ? new PropertiesSentinel(this.getStandalone().getDatabase(), sentinel) : null;
    }

    @Override
    public RedisConnectionDetails.Cluster getCluster() {
        RedisProperties.Cluster cluster = this.properties.getCluster();
        return cluster != null ? new PropertiesCluster(cluster) : null;
    }

    private RedisUrl getRedisUrl() {
        return RedisUrl.of(this.properties.getUrl());
    }

    private List<RedisConnectionDetails.Node> asNodes(List<String> nodes) {
        return nodes.stream().map(this::asNode).toList();
    }

    private RedisConnectionDetails.Node asNode(String node) {
        int portSeparatorIndex = node.lastIndexOf(58);
        String host = node.substring(0, portSeparatorIndex);
        int port = Integer.parseInt(node.substring(portSeparatorIndex + 1));
        return new RedisConnectionDetails.Node(host, port);
    }

    private class PropertiesSentinel
    implements RedisConnectionDetails.Sentinel {
        private final int database;
        private final RedisProperties.Sentinel properties;

        PropertiesSentinel(int database, RedisProperties.Sentinel properties) {
            this.database = database;
            this.properties = properties;
        }

        @Override
        public int getDatabase() {
            return this.database;
        }

        @Override
        public String getMaster() {
            return this.properties.getMaster();
        }

        @Override
        public List<RedisConnectionDetails.Node> getNodes() {
            return PropertiesRedisConnectionDetails.this.asNodes(this.properties.getNodes());
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public SslBundle getSslBundle() {
            return PropertiesRedisConnectionDetails.this.getSslBundle();
        }
    }

    private class PropertiesCluster
    implements RedisConnectionDetails.Cluster {
        private final List<RedisConnectionDetails.Node> nodes;

        PropertiesCluster(RedisProperties.Cluster properties) {
            this.nodes = PropertiesRedisConnectionDetails.this.asNodes(properties.getNodes());
        }

        @Override
        public List<RedisConnectionDetails.Node> getNodes() {
            return this.nodes;
        }

        @Override
        public SslBundle getSslBundle() {
            return PropertiesRedisConnectionDetails.this.getSslBundle();
        }
    }
}

