/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

final class ClassPath {
    private static final Collector<CharSequence, ?, String> JOIN_BY_PATH_SEPARATOR = Collectors.joining(File.pathSeparator);
    private final boolean preferArgFile;
    private final String path;

    private ClassPath(boolean preferArgFile, String path) {
        this.preferArgFile = preferArgFile;
        this.path = path;
    }

    List<String> args(boolean allowArgFile) {
        return !this.path.isEmpty() ? List.of("-cp", this.classPathArg(allowArgFile)) : Collections.emptyList();
    }

    private String classPathArg(boolean allowArgFile) {
        if (this.preferArgFile && allowArgFile) {
            try {
                return "@" + String.valueOf(this.createArgFile());
            }
            catch (IOException ex) {
                return this.path;
            }
        }
        return this.path;
    }

    public String toString() {
        return this.path;
    }

    private Path createArgFile() throws IOException {
        Path argFile = Files.createTempFile("spring-boot-", ".argfile", new FileAttribute[0]);
        argFile.toFile().deleteOnExit();
        Files.writeString(argFile, (CharSequence)("\"" + this.path.replace("\\", "\\\\") + "\""), this.charset(), new OpenOption[0]);
        return argFile;
    }

    private Charset charset() {
        try {
            String nativeEncoding = System.getProperty("native.encoding");
            return nativeEncoding != null ? Charset.forName(nativeEncoding) : Charset.defaultCharset();
        }
        catch (UnsupportedCharsetException ex) {
            return Charset.defaultCharset();
        }
    }

    static ClassPath of(URL ... urls) {
        return ClassPath.of(Arrays.asList(urls));
    }

    static ClassPath of(List<URL> urls) {
        return ClassPath.of(System::getProperty, urls);
    }

    static ClassPath of(UnaryOperator<@Nullable String> getSystemProperty, List<URL> urls) {
        boolean preferArgFile = urls.size() > 1 && ClassPath.isWindows(getSystemProperty);
        return new ClassPath(preferArgFile, urls.stream().map(ClassPath::toPathString).collect(JOIN_BY_PATH_SEPARATOR));
    }

    private static boolean isWindows(UnaryOperator<@Nullable String> getSystemProperty) {
        String os = (String)getSystemProperty.apply("os.name");
        return StringUtils.hasText((String)os) && os.toLowerCase(Locale.ROOT).contains("win");
    }

    private static String toPathString(URL url) {
        try {
            return Paths.get(url.toURI()).toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

