/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.actuate.reactive;

import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.security.autoconfigure.actuate.reactive.EndpointRequest;
import org.springframework.boot.security.autoconfigure.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.security.autoconfigure.reactive.ReactiveUserDetailsServiceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.cors.reactive.PreFlightRequestHandler;
import org.springframework.web.cors.reactive.PreFlightRequestWebFilter;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@AutoConfiguration(before={ReactiveSecurityAutoConfiguration.class}, after={ReactiveUserDetailsServiceAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration"})
@ConditionalOnClass(value={EnableWebFluxSecurity.class, WebFilterChainProxy.class, WebEndpointAutoConfiguration.class})
@ConditionalOnMissingBean(value={SecurityWebFilterChain.class, WebFilterChainProxy.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public final class ReactiveManagementWebSecurityAutoConfiguration {
    @Bean
    SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, PreFlightRequestHandler handler) {
        http.authorizeExchange(exchanges -> {
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchanges.matchers(new ServerWebExchangeMatcher[]{this.healthMatcher(), this.additionalHealthPathsMatcher()})).permitAll();
            exchanges.anyExchange().authenticated();
        });
        PreFlightRequestWebFilter filter = new PreFlightRequestWebFilter(handler);
        http.addFilterAt((WebFilter)filter, SecurityWebFiltersOrder.CORS);
        http.httpBasic(Customizer.withDefaults());
        http.formLogin(Customizer.withDefaults());
        return http.build();
    }

    private ServerWebExchangeMatcher healthMatcher() {
        return EndpointRequest.to(HealthEndpoint.class);
    }

    private ServerWebExchangeMatcher additionalHealthPathsMatcher() {
        return EndpointRequest.toAdditionalPaths(WebServerNamespace.SERVER, HealthEndpoint.class);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveAuthenticationManager.class, ReactiveUserDetailsService.class})
    ReactiveAuthenticationManager denyAllAuthenticationManager() {
        return authentication -> Mono.error((Throwable)new UsernameNotFoundException(authentication.getName()));
    }
}

