/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.restclient.test.MockServerRestClientCustomizer;
import org.springframework.boot.restclient.test.MockServerRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnClass(value={MockServerRestTemplateCustomizer.class})
@ConditionalOnBooleanProperty(value={"spring.test.webclient.mockrestserviceserver.enabled"})
public class MockRestServiceServerAutoConfiguration {
    @Bean
    public MockServerRestTemplateCustomizer mockServerRestTemplateCustomizer() {
        return new MockServerRestTemplateCustomizer();
    }

    @Bean
    public MockServerRestClientCustomizer mockServerRestClientCustomizer() {
        return new MockServerRestClientCustomizer();
    }

    @Bean
    public MockRestServiceServer mockRestServiceServer(MockServerRestTemplateCustomizer restTemplateCustomizer, MockServerRestClientCustomizer restClientCustomizer) {
        try {
            return this.createDeferredMockRestServiceServer(restTemplateCustomizer, restClientCustomizer);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private MockRestServiceServer createDeferredMockRestServiceServer(MockServerRestTemplateCustomizer restTemplateCustomizer, MockServerRestClientCustomizer restClientCustomizer) throws Exception {
        Constructor constructor = MockRestServiceServer.class.getDeclaredConstructor(RequestExpectationManager.class);
        constructor.setAccessible(true);
        return (MockRestServiceServer)constructor.newInstance(new DeferredRequestExpectationManager(restTemplateCustomizer, restClientCustomizer));
    }

    private static class DeferredRequestExpectationManager
    implements RequestExpectationManager {
        private final MockServerRestTemplateCustomizer restTemplateCustomizer;
        private final MockServerRestClientCustomizer restClientCustomizer;

        DeferredRequestExpectationManager(MockServerRestTemplateCustomizer restTemplateCustomizer, MockServerRestClientCustomizer restClientCustomizer) {
            this.restTemplateCustomizer = restTemplateCustomizer;
            this.restClientCustomizer = restClientCustomizer;
        }

        public ResponseActions expectRequest(ExpectedCount count, RequestMatcher requestMatcher) {
            return this.getDelegate().expectRequest(count, requestMatcher);
        }

        public ClientHttpResponse validateRequest(ClientHttpRequest request) throws IOException {
            return this.getDelegate().validateRequest(request);
        }

        public void verify() {
            this.getDelegate().verify();
        }

        public void verify(Duration timeout) {
            this.getDelegate().verify(timeout);
        }

        public void reset() {
            this.resetExpectations(this.restTemplateCustomizer.getExpectationManagers().values());
            this.resetExpectations(this.restClientCustomizer.getExpectationManagers().values());
        }

        private void resetExpectations(Collection<RequestExpectationManager> expectationManagers) {
            if (expectationManagers.size() == 1) {
                expectationManagers.iterator().next().reset();
            }
        }

        private RequestExpectationManager getDelegate() {
            Map restTemplateExpectationManagers = this.restTemplateCustomizer.getExpectationManagers();
            Map restClientExpectationManagers = this.restClientCustomizer.getExpectationManagers();
            boolean neitherBound = restTemplateExpectationManagers.isEmpty() && restClientExpectationManagers.isEmpty();
            boolean bothBound = !restTemplateExpectationManagers.isEmpty() && !restClientExpectationManagers.isEmpty();
            Assert.state((!neitherBound ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since a mock server customizer has not been bound to a RestTemplate or RestClient");
            Assert.state((!bothBound ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since mock server customizers have been bound to both a RestTemplate and a RestClient");
            if (!restTemplateExpectationManagers.isEmpty()) {
                Assert.state((restTemplateExpectationManagers.size() == 1 ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since MockServerRestTemplateCustomizer has been bound to more than one RestTemplate");
                return (RequestExpectationManager)restTemplateExpectationManagers.values().iterator().next();
            }
            Assert.state((restClientExpectationManagers.size() == 1 ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since MockServerRestClientCustomizer has been bound to more than one RestClient");
            return (RequestExpectationManager)restClientExpectationManagers.values().iterator().next();
        }
    }
}

