/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.io.ClientConnector;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.JettyHttpClientBuilder;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JettyClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<JettyClientHttpRequestFactory> {
    private final JettyHttpClientBuilder httpClientBuilder;

    JettyClientHttpRequestFactoryBuilder() {
        this(null, new JettyHttpClientBuilder());
    }

    private JettyClientHttpRequestFactoryBuilder(List<Consumer<JettyClientHttpRequestFactory>> customizers, JettyHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public JettyClientHttpRequestFactoryBuilder withCustomizer(Consumer<JettyClientHttpRequestFactory> customizer) {
        return new JettyClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public JettyClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<JettyClientHttpRequestFactory>> customizers) {
        return new JettyClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public JettyClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public JettyClientHttpRequestFactoryBuilder withHttpClientTransportCustomizer(Consumer<HttpClientTransport> httpClientTransportCustomizer) {
        Assert.notNull(httpClientTransportCustomizer, (String)"'httpClientTransportCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientTransportCustomizer(httpClientTransportCustomizer));
    }

    public JettyClientHttpRequestFactoryBuilder withClientConnectorCustomizerCustomizer(Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        Assert.notNull(clientConnectorCustomizerCustomizer, (String)"'clientConnectorCustomizerCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withClientConnectorCustomizerCustomizer(clientConnectorCustomizerCustomizer));
    }

    @Override
    protected JettyClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings.withTimeouts(null, null)));
        JettyClientHttpRequestFactory requestFactory = new JettyClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((JettyClientHttpRequestFactory)requestFactory).setConnectTimeout(arg_0));
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(arg_0 -> ((JettyClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
        return requestFactory;
    }

    static class Classes {
        static final String HTTP_CLIENT = "org.eclipse.jetty.client.HttpClient";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENT, (ClassLoader)classLoader);
        }
    }
}

