/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.DataStoreRenderConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.GraphQLRenderConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.NoApiRenderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiConfiguration> {
    private static final SdkField<GraphQLRenderConfig> GRAPH_QL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("graphQLConfig").getter(ApiConfiguration.getter(ApiConfiguration::graphQLConfig)).setter(ApiConfiguration.setter(Builder::graphQLConfig)).constructor(GraphQLRenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphQLConfig").build()}).build();
    private static final SdkField<DataStoreRenderConfig> DATA_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataStoreConfig").getter(ApiConfiguration.getter(ApiConfiguration::dataStoreConfig)).setter(ApiConfiguration.setter(Builder::dataStoreConfig)).constructor(DataStoreRenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStoreConfig").build()}).build();
    private static final SdkField<NoApiRenderConfig> NO_API_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("noApiConfig").getter(ApiConfiguration.getter(ApiConfiguration::noApiConfig)).setter(ApiConfiguration.setter(Builder::noApiConfig)).constructor(NoApiRenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noApiConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_QL_CONFIG_FIELD, DATA_STORE_CONFIG_FIELD, NO_API_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GraphQLRenderConfig graphQLConfig;
    private final DataStoreRenderConfig dataStoreConfig;
    private final NoApiRenderConfig noApiConfig;
    private final Type type;

    private ApiConfiguration(BuilderImpl builder) {
        this.graphQLConfig = builder.graphQLConfig;
        this.dataStoreConfig = builder.dataStoreConfig;
        this.noApiConfig = builder.noApiConfig;
        this.type = builder.type;
    }

    public final GraphQLRenderConfig graphQLConfig() {
        return this.graphQLConfig;
    }

    public final DataStoreRenderConfig dataStoreConfig() {
        return this.dataStoreConfig;
    }

    public final NoApiRenderConfig noApiConfig() {
        return this.noApiConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.graphQLConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.noApiConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiConfiguration)) {
            return false;
        }
        ApiConfiguration other = (ApiConfiguration)obj;
        return Objects.equals(this.graphQLConfig(), other.graphQLConfig()) && Objects.equals(this.dataStoreConfig(), other.dataStoreConfig()) && Objects.equals(this.noApiConfig(), other.noApiConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ApiConfiguration").add("GraphQLConfig", (Object)this.graphQLConfig()).add("DataStoreConfig", (Object)this.dataStoreConfig()).add("NoApiConfig", (Object)this.noApiConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphQLConfig": {
                return Optional.ofNullable(clazz.cast(this.graphQLConfig()));
            }
            case "dataStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.dataStoreConfig()));
            }
            case "noApiConfig": {
                return Optional.ofNullable(clazz.cast(this.noApiConfig()));
            }
        }
        return Optional.empty();
    }

    public static ApiConfiguration fromGraphQLConfig(GraphQLRenderConfig graphQLConfig) {
        return (ApiConfiguration)ApiConfiguration.builder().graphQLConfig(graphQLConfig).build();
    }

    public static ApiConfiguration fromGraphQLConfig(Consumer<GraphQLRenderConfig.Builder> graphQLConfig) {
        GraphQLRenderConfig.Builder builder = GraphQLRenderConfig.builder();
        graphQLConfig.accept(builder);
        return ApiConfiguration.fromGraphQLConfig((GraphQLRenderConfig)builder.build());
    }

    public static ApiConfiguration fromDataStoreConfig(DataStoreRenderConfig dataStoreConfig) {
        return (ApiConfiguration)ApiConfiguration.builder().dataStoreConfig(dataStoreConfig).build();
    }

    public static ApiConfiguration fromDataStoreConfig(Consumer<DataStoreRenderConfig.Builder> dataStoreConfig) {
        DataStoreRenderConfig.Builder builder = DataStoreRenderConfig.builder();
        dataStoreConfig.accept(builder);
        return ApiConfiguration.fromDataStoreConfig((DataStoreRenderConfig)builder.build());
    }

    public static ApiConfiguration fromNoApiConfig(NoApiRenderConfig noApiConfig) {
        return (ApiConfiguration)ApiConfiguration.builder().noApiConfig(noApiConfig).build();
    }

    public static ApiConfiguration fromNoApiConfig(Consumer<NoApiRenderConfig.Builder> noApiConfig) {
        NoApiRenderConfig.Builder builder = NoApiRenderConfig.builder();
        noApiConfig.accept(builder);
        return ApiConfiguration.fromNoApiConfig((NoApiRenderConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("graphQLConfig", GRAPH_QL_CONFIG_FIELD);
        map.put("dataStoreConfig", DATA_STORE_CONFIG_FIELD);
        map.put("noApiConfig", NO_API_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiConfiguration, T> g) {
        return obj -> g.apply((ApiConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GRAPH_QL_CONFIG,
        DATA_STORE_CONFIG,
        NO_API_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GraphQLRenderConfig graphQLConfig;
        private DataStoreRenderConfig dataStoreConfig;
        private NoApiRenderConfig noApiConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ApiConfiguration model) {
            this.graphQLConfig(model.graphQLConfig);
            this.dataStoreConfig(model.dataStoreConfig);
            this.noApiConfig(model.noApiConfig);
        }

        public final GraphQLRenderConfig.Builder getGraphQLConfig() {
            return this.graphQLConfig != null ? this.graphQLConfig.toBuilder() : null;
        }

        public final void setGraphQLConfig(GraphQLRenderConfig.BuilderImpl graphQLConfig) {
            GraphQLRenderConfig oldValue = this.graphQLConfig;
            this.graphQLConfig = graphQLConfig != null ? graphQLConfig.build() : null;
            this.handleUnionValueChange(Type.GRAPH_QL_CONFIG, oldValue, this.graphQLConfig);
        }

        @Override
        public final Builder graphQLConfig(GraphQLRenderConfig graphQLConfig) {
            GraphQLRenderConfig oldValue = this.graphQLConfig;
            this.graphQLConfig = graphQLConfig;
            this.handleUnionValueChange(Type.GRAPH_QL_CONFIG, oldValue, this.graphQLConfig);
            return this;
        }

        public final DataStoreRenderConfig.Builder getDataStoreConfig() {
            return this.dataStoreConfig != null ? this.dataStoreConfig.toBuilder() : null;
        }

        public final void setDataStoreConfig(DataStoreRenderConfig.BuilderImpl dataStoreConfig) {
            DataStoreRenderConfig oldValue = this.dataStoreConfig;
            this.dataStoreConfig = dataStoreConfig != null ? dataStoreConfig.build() : null;
            this.handleUnionValueChange(Type.DATA_STORE_CONFIG, oldValue, this.dataStoreConfig);
        }

        @Override
        public final Builder dataStoreConfig(DataStoreRenderConfig dataStoreConfig) {
            DataStoreRenderConfig oldValue = this.dataStoreConfig;
            this.dataStoreConfig = dataStoreConfig;
            this.handleUnionValueChange(Type.DATA_STORE_CONFIG, oldValue, this.dataStoreConfig);
            return this;
        }

        public final NoApiRenderConfig.Builder getNoApiConfig() {
            return this.noApiConfig != null ? this.noApiConfig.toBuilder() : null;
        }

        public final void setNoApiConfig(NoApiRenderConfig.BuilderImpl noApiConfig) {
            NoApiRenderConfig oldValue = this.noApiConfig;
            this.noApiConfig = noApiConfig != null ? noApiConfig.build() : null;
            this.handleUnionValueChange(Type.NO_API_CONFIG, oldValue, this.noApiConfig);
        }

        @Override
        public final Builder noApiConfig(NoApiRenderConfig noApiConfig) {
            NoApiRenderConfig oldValue = this.noApiConfig;
            this.noApiConfig = noApiConfig;
            this.handleUnionValueChange(Type.NO_API_CONFIG, oldValue, this.noApiConfig);
            return this;
        }

        public ApiConfiguration build() {
            return new ApiConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiConfiguration> {
        public Builder graphQLConfig(GraphQLRenderConfig var1);

        default public Builder graphQLConfig(Consumer<GraphQLRenderConfig.Builder> graphQLConfig) {
            return this.graphQLConfig((GraphQLRenderConfig)((GraphQLRenderConfig.Builder)GraphQLRenderConfig.builder().applyMutation(graphQLConfig)).build());
        }

        public Builder dataStoreConfig(DataStoreRenderConfig var1);

        default public Builder dataStoreConfig(Consumer<DataStoreRenderConfig.Builder> dataStoreConfig) {
            return this.dataStoreConfig((DataStoreRenderConfig)((DataStoreRenderConfig.Builder)DataStoreRenderConfig.builder().applyMutation(dataStoreConfig)).build());
        }

        public Builder noApiConfig(NoApiRenderConfig var1);

        default public Builder noApiConfig(Consumer<NoApiRenderConfig.Builder> noApiConfig) {
            return this.noApiConfig((NoApiRenderConfig)((NoApiRenderConfig.Builder)NoApiRenderConfig.builder().applyMutation(noApiConfig)).build());
        }
    }
}

