/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MatchingStrategy {
    MATCH_ANY("MatchAny"),
    MATCH_MOST_SIGNIFICANT_ROAD("MatchMostSignificantRoad"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatchingStrategy> VALUE_MAP;
    private final String value;

    private MatchingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatchingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatchingStrategy> knownValues() {
        EnumSet<MatchingStrategy> knownValues = EnumSet.allOf(MatchingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MatchingStrategy.class, MatchingStrategy::toString);
    }
}

