/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoadSnapNoticeCode {
    TRACE_POINTS_HEADING_IGNORED("TracePointsHeadingIgnored"),
    TRACE_POINTS_IGNORED("TracePointsIgnored"),
    TRACE_POINTS_MOVED_BY_LARGE_DISTANCE("TracePointsMovedByLargeDistance"),
    TRACE_POINTS_NOT_MATCHED("TracePointsNotMatched"),
    TRACE_POINTS_OUT_OF_SEQUENCE("TracePointsOutOfSequence"),
    TRACE_POINTS_SPEED_ESTIMATED("TracePointsSpeedEstimated"),
    TRACE_POINTS_SPEED_IGNORED("TracePointsSpeedIgnored"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoadSnapNoticeCode> VALUE_MAP;
    private final String value;

    private RoadSnapNoticeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoadSnapNoticeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoadSnapNoticeCode> knownValues() {
        EnumSet<RoadSnapNoticeCode> knownValues = EnumSet.allOf(RoadSnapNoticeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoadSnapNoticeCode.class, RoadSnapNoticeCode::toString);
    }
}

