/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.BoundingBoxCopier;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixAvoidanceAreaGeometryPolygonListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixAvoidanceAreaGeometryPolylinePolygonListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixAvoidanceAreaGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixAvoidanceAreaGeometry> {
    private static final SdkField<List<Double>> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BoundingBox").getter(RouteMatrixAvoidanceAreaGeometry.getter(RouteMatrixAvoidanceAreaGeometry::boundingBox)).setter(RouteMatrixAvoidanceAreaGeometry.setter(Builder::boundingBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<List<Double>>>> POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Polygon").getter(RouteMatrixAvoidanceAreaGeometry.getter(RouteMatrixAvoidanceAreaGeometry::polygon)).setter(RouteMatrixAvoidanceAreaGeometry.setter(Builder::polygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> POLYLINE_POLYGON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolylinePolygon").getter(RouteMatrixAvoidanceAreaGeometry.getter(RouteMatrixAvoidanceAreaGeometry::polylinePolygon)).setter(RouteMatrixAvoidanceAreaGeometry.setter(Builder::polylinePolygon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolylinePolygon").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, POLYGON_FIELD, POLYLINE_POLYGON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixAvoidanceAreaGeometry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> boundingBox;
    private final List<List<List<Double>>> polygon;
    private final List<String> polylinePolygon;

    private RouteMatrixAvoidanceAreaGeometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
        this.polylinePolygon = builder.polylinePolygon;
    }

    public final boolean hasBoundingBox() {
        return this.boundingBox != null && !(this.boundingBox instanceof SdkAutoConstructList);
    }

    public final List<Double> boundingBox() {
        return this.boundingBox;
    }

    public final boolean hasPolygon() {
        return this.polygon != null && !(this.polygon instanceof SdkAutoConstructList);
    }

    public final List<List<List<Double>>> polygon() {
        return this.polygon;
    }

    public final boolean hasPolylinePolygon() {
        return this.polylinePolygon != null && !(this.polylinePolygon instanceof SdkAutoConstructList);
    }

    public final List<String> polylinePolygon() {
        return this.polylinePolygon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBoundingBox() ? this.boundingBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolygon() ? this.polygon() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolylinePolygon() ? this.polylinePolygon() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixAvoidanceAreaGeometry)) {
            return false;
        }
        RouteMatrixAvoidanceAreaGeometry other = (RouteMatrixAvoidanceAreaGeometry)obj;
        return this.hasBoundingBox() == other.hasBoundingBox() && Objects.equals(this.boundingBox(), other.boundingBox()) && this.hasPolygon() == other.hasPolygon() && Objects.equals(this.polygon(), other.polygon()) && this.hasPolylinePolygon() == other.hasPolylinePolygon() && Objects.equals(this.polylinePolygon(), other.polylinePolygon());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixAvoidanceAreaGeometry").add("BoundingBox", (Object)(this.boundingBox() == null ? null : "*** Sensitive Data Redacted ***")).add("Polygon", (Object)(this.polygon() == null ? null : "*** Sensitive Data Redacted ***")).add("PolylinePolygon", (Object)(this.polylinePolygon() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
            case "PolylinePolygon": {
                return Optional.ofNullable(clazz.cast(this.polylinePolygon()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        map.put("Polygon", POLYGON_FIELD);
        map.put("PolylinePolygon", POLYLINE_POLYGON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixAvoidanceAreaGeometry, T> g) {
        return obj -> g.apply((RouteMatrixAvoidanceAreaGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> boundingBox = DefaultSdkAutoConstructList.getInstance();
        private List<List<List<Double>>> polygon = DefaultSdkAutoConstructList.getInstance();
        private List<String> polylinePolygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixAvoidanceAreaGeometry model) {
            this.boundingBox(model.boundingBox);
            this.polygon(model.polygon);
            this.polylinePolygon(model.polylinePolygon);
        }

        public final Collection<Double> getBoundingBox() {
            if (this.boundingBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.boundingBox;
        }

        public final void setBoundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
        }

        @Override
        public final Builder boundingBox(Collection<Double> boundingBox) {
            this.boundingBox = BoundingBoxCopier.copy(boundingBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder boundingBox(Double ... boundingBox) {
            this.boundingBox(Arrays.asList(boundingBox));
            return this;
        }

        public final Collection<? extends Collection<? extends Collection<Double>>> getPolygon() {
            if (this.polygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polygon;
        }

        public final void setPolygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixAvoidanceAreaGeometryPolygonListCopier.copy(polygon);
        }

        @Override
        public final Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> polygon) {
            this.polygon = RouteMatrixAvoidanceAreaGeometryPolygonListCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Collection<? extends Collection<Double>> ... polygon) {
            this.polygon((Collection<? extends Collection<? extends Collection<Double>>>)Arrays.asList(polygon));
            return this;
        }

        public final Collection<String> getPolylinePolygon() {
            if (this.polylinePolygon instanceof SdkAutoConstructList) {
                return null;
            }
            return this.polylinePolygon;
        }

        public final void setPolylinePolygon(Collection<String> polylinePolygon) {
            this.polylinePolygon = RouteMatrixAvoidanceAreaGeometryPolylinePolygonListCopier.copy(polylinePolygon);
        }

        @Override
        public final Builder polylinePolygon(Collection<String> polylinePolygon) {
            this.polylinePolygon = RouteMatrixAvoidanceAreaGeometryPolylinePolygonListCopier.copy(polylinePolygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polylinePolygon(String ... polylinePolygon) {
            this.polylinePolygon(Arrays.asList(polylinePolygon));
            return this;
        }

        public RouteMatrixAvoidanceAreaGeometry build() {
            return new RouteMatrixAvoidanceAreaGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixAvoidanceAreaGeometry> {
        public Builder boundingBox(Collection<Double> var1);

        public Builder boundingBox(Double ... var1);

        public Builder polygon(Collection<? extends Collection<? extends Collection<Double>>> var1);

        public Builder polygon(Collection<? extends Collection<Double>> ... var1);

        public Builder polylinePolygon(Collection<String> var1);

        public Builder polylinePolygon(String ... var1);
    }
}

