/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SecretsManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorDestinationRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateConnectorDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::name)).setter(CreateConnectorDestinationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::description)).setter(CreateConnectorDestinationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLOUD_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudConnectorId").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::cloudConnectorId)).setter(CreateConnectorDestinationRequest.setter(Builder::cloudConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudConnectorId").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::authTypeAsString)).setter(CreateConnectorDestinationRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<AuthConfig> AUTH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthConfig").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::authConfig)).setter(CreateConnectorDestinationRequest.setter(Builder::authConfig)).constructor(AuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthConfig").build()}).build();
    private static final SdkField<SecretsManager> SECRETS_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManager").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::secretsManager)).setter(CreateConnectorDestinationRequest.setter(Builder::secretsManager)).constructor(SecretsManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManager").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateConnectorDestinationRequest.getter(CreateConnectorDestinationRequest::clientToken)).setter(CreateConnectorDestinationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLOUD_CONNECTOR_ID_FIELD, AUTH_TYPE_FIELD, AUTH_CONFIG_FIELD, SECRETS_MANAGER_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorDestinationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String cloudConnectorId;
    private final String authType;
    private final AuthConfig authConfig;
    private final SecretsManager secretsManager;
    private final String clientToken;

    private CreateConnectorDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.cloudConnectorId = builder.cloudConnectorId;
        this.authType = builder.authType;
        this.authConfig = builder.authConfig;
        this.secretsManager = builder.secretsManager;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String cloudConnectorId() {
        return this.cloudConnectorId;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final AuthConfig authConfig() {
        return this.authConfig;
    }

    public final SecretsManager secretsManager() {
        return this.secretsManager;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorDestinationRequest)) {
            return false;
        }
        CreateConnectorDestinationRequest other = (CreateConnectorDestinationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cloudConnectorId(), other.cloudConnectorId()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authConfig(), other.authConfig()) && Objects.equals(this.secretsManager(), other.secretsManager()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorDestinationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CloudConnectorId", (Object)this.cloudConnectorId()).add("AuthType", (Object)this.authTypeAsString()).add("AuthConfig", (Object)this.authConfig()).add("SecretsManager", (Object)this.secretsManager()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CloudConnectorId": {
                return Optional.ofNullable(clazz.cast(this.cloudConnectorId()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthConfig": {
                return Optional.ofNullable(clazz.cast(this.authConfig()));
            }
            case "SecretsManager": {
                return Optional.ofNullable(clazz.cast(this.secretsManager()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CloudConnectorId", CLOUD_CONNECTOR_ID_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthConfig", AUTH_CONFIG_FIELD);
        map.put("SecretsManager", SECRETS_MANAGER_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorDestinationRequest, T> g) {
        return obj -> g.apply((CreateConnectorDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String cloudConnectorId;
        private String authType;
        private AuthConfig authConfig;
        private SecretsManager secretsManager;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorDestinationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.cloudConnectorId(model.cloudConnectorId);
            this.authType(model.authType);
            this.authConfig(model.authConfig);
            this.secretsManager(model.secretsManager);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCloudConnectorId() {
            return this.cloudConnectorId;
        }

        public final void setCloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
        }

        @Override
        public final Builder cloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final AuthConfig.Builder getAuthConfig() {
            return this.authConfig != null ? this.authConfig.toBuilder() : null;
        }

        public final void setAuthConfig(AuthConfig.BuilderImpl authConfig) {
            this.authConfig = authConfig != null ? authConfig.build() : null;
        }

        @Override
        public final Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public final SecretsManager.Builder getSecretsManager() {
            return this.secretsManager != null ? this.secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManager.BuilderImpl secretsManager) {
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
        }

        @Override
        public final Builder secretsManager(SecretsManager secretsManager) {
            this.secretsManager = secretsManager;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorDestinationRequest build() {
            return new CreateConnectorDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorDestinationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder cloudConnectorId(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder authConfig(AuthConfig var1);

        default public Builder authConfig(Consumer<AuthConfig.Builder> authConfig) {
            return this.authConfig((AuthConfig)((AuthConfig.Builder)AuthConfig.builder().applyMutation(authConfig)).build());
        }

        public Builder secretsManager(SecretsManager var1);

        default public Builder secretsManager(Consumer<SecretsManager.Builder> secretsManager) {
            return this.secretsManager((SecretsManager)((SecretsManager.Builder)SecretsManager.builder().applyMutation(secretsManager)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

