/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MetaDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedThingMetaDataResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetManagedThingMetaDataResponse> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedThingId").getter(GetManagedThingMetaDataResponse.getter(GetManagedThingMetaDataResponse::managedThingId)).setter(GetManagedThingMetaDataResponse.setter(Builder::managedThingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()}).build();
    private static final SdkField<Map<String, String>> META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetaData").getter(GetManagedThingMetaDataResponse.getter(GetManagedThingMetaDataResponse::metaData)).setter(GetManagedThingMetaDataResponse.setter(Builder::metaData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD, META_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedThingMetaDataResponse.memberNameToFieldInitializer();
    private final String managedThingId;
    private final Map<String, String> metaData;

    private GetManagedThingMetaDataResponse(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.metaData = builder.metaData;
    }

    public final String managedThingId() {
        return this.managedThingId;
    }

    public final boolean hasMetaData() {
        return this.metaData != null && !(this.metaData instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metaData() {
        return this.metaData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetaData() ? this.metaData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingMetaDataResponse)) {
            return false;
        }
        GetManagedThingMetaDataResponse other = (GetManagedThingMetaDataResponse)((Object)obj);
        return Objects.equals(this.managedThingId(), other.managedThingId()) && this.hasMetaData() == other.hasMetaData() && Objects.equals(this.metaData(), other.metaData());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedThingMetaDataResponse").add("ManagedThingId", (Object)this.managedThingId()).add("MetaData", this.hasMetaData() ? this.metaData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedThingId": {
                return Optional.ofNullable(clazz.cast(this.managedThingId()));
            }
            case "MetaData": {
                return Optional.ofNullable(clazz.cast(this.metaData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingMetaDataResponse, T> g) {
        return obj -> g.apply((GetManagedThingMetaDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String managedThingId;
        private Map<String, String> metaData = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingMetaDataResponse model) {
            super(model);
            this.managedThingId(model.managedThingId);
            this.metaData(model.metaData);
        }

        public final String getManagedThingId() {
            return this.managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final Map<String, String> getMetaData() {
            if (this.metaData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metaData;
        }

        public final void setMetaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
        }

        @Override
        public final Builder metaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
            return this;
        }

        @Override
        public GetManagedThingMetaDataResponse build() {
            return new GetManagedThingMetaDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedThingMetaDataResponse> {
        public Builder managedThingId(String var1);

        public Builder metaData(Map<String, String> var1);
    }
}

