/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.HubNetworkMode;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MetaDataCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.Role;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedThingResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetManagedThingResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetManagedThingResponse.getter(GetManagedThingResponse::id)).setter(GetManagedThingResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetManagedThingResponse.getter(GetManagedThingResponse::arn)).setter(GetManagedThingResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(GetManagedThingResponse.getter(GetManagedThingResponse::owner)).setter(GetManagedThingResponse.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> CREDENTIAL_LOCKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialLockerId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::credentialLockerId)).setter(GetManagedThingResponse.setter(Builder::credentialLockerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialLockerId").build()}).build();
    private static final SdkField<String> ADVERTISED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdvertisedProductId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::advertisedProductId)).setter(GetManagedThingResponse.setter(Builder::advertisedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvertisedProductId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(GetManagedThingResponse.getter(GetManagedThingResponse::roleAsString)).setter(GetManagedThingResponse.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(GetManagedThingResponse.getter(GetManagedThingResponse::provisioningStatusAsString)).setter(GetManagedThingResponse.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetManagedThingResponse.getter(GetManagedThingResponse::name)).setter(GetManagedThingResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(GetManagedThingResponse.getter(GetManagedThingResponse::model)).setter(GetManagedThingResponse.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(GetManagedThingResponse.getter(GetManagedThingResponse::brand)).setter(GetManagedThingResponse.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(GetManagedThingResponse.getter(GetManagedThingResponse::serialNumber)).setter(GetManagedThingResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> UNIVERSAL_PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniversalProductCode").getter(GetManagedThingResponse.getter(GetManagedThingResponse::universalProductCode)).setter(GetManagedThingResponse.setter(Builder::universalProductCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniversalProductCode").build()}).build();
    private static final SdkField<String> INTERNATIONAL_ARTICLE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternationalArticleNumber").getter(GetManagedThingResponse.getter(GetManagedThingResponse::internationalArticleNumber)).setter(GetManagedThingResponse.setter(Builder::internationalArticleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternationalArticleNumber").build()}).build();
    private static final SdkField<String> CONNECTOR_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorPolicyId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::connectorPolicyId)).setter(GetManagedThingResponse.setter(Builder::connectorPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorPolicyId").build()}).build();
    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDestinationId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::connectorDestinationId)).setter(GetManagedThingResponse.setter(Builder::connectorDestinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationId").build()}).build();
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDeviceId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::connectorDeviceId)).setter(GetManagedThingResponse.setter(Builder::connectorDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()}).build();
    private static final SdkField<String> DEVICE_SPECIFIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSpecificKey").getter(GetManagedThingResponse.getter(GetManagedThingResponse::deviceSpecificKey)).setter(GetManagedThingResponse.setter(Builder::deviceSpecificKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSpecificKey").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(GetManagedThingResponse.getter(GetManagedThingResponse::macAddress)).setter(GetManagedThingResponse.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()}).build();
    private static final SdkField<String> PARENT_CONTROLLER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentControllerId").getter(GetManagedThingResponse.getter(GetManagedThingResponse::parentControllerId)).setter(GetManagedThingResponse.setter(Builder::parentControllerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentControllerId").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(GetManagedThingResponse.getter(GetManagedThingResponse::classification)).setter(GetManagedThingResponse.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetManagedThingResponse.getter(GetManagedThingResponse::createdAt)).setter(GetManagedThingResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetManagedThingResponse.getter(GetManagedThingResponse::updatedAt)).setter(GetManagedThingResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Instant> ACTIVATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActivatedAt").getter(GetManagedThingResponse.getter(GetManagedThingResponse::activatedAt)).setter(GetManagedThingResponse.setter(Builder::activatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedAt").build()}).build();
    private static final SdkField<String> HUB_NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubNetworkMode").getter(GetManagedThingResponse.getter(GetManagedThingResponse::hubNetworkModeAsString)).setter(GetManagedThingResponse.setter(Builder::hubNetworkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubNetworkMode").build()}).build();
    private static final SdkField<Map<String, String>> META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetaData").getter(GetManagedThingResponse.getter(GetManagedThingResponse::metaData)).setter(GetManagedThingResponse.setter(Builder::metaData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetManagedThingResponse.getter(GetManagedThingResponse::tags)).setter(GetManagedThingResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, OWNER_FIELD, CREDENTIAL_LOCKER_ID_FIELD, ADVERTISED_PRODUCT_ID_FIELD, ROLE_FIELD, PROVISIONING_STATUS_FIELD, NAME_FIELD, MODEL_FIELD, BRAND_FIELD, SERIAL_NUMBER_FIELD, UNIVERSAL_PRODUCT_CODE_FIELD, INTERNATIONAL_ARTICLE_NUMBER_FIELD, CONNECTOR_POLICY_ID_FIELD, CONNECTOR_DESTINATION_ID_FIELD, CONNECTOR_DEVICE_ID_FIELD, DEVICE_SPECIFIC_KEY_FIELD, MAC_ADDRESS_FIELD, PARENT_CONTROLLER_ID_FIELD, CLASSIFICATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ACTIVATED_AT_FIELD, HUB_NETWORK_MODE_FIELD, META_DATA_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedThingResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String owner;
    private final String credentialLockerId;
    private final String advertisedProductId;
    private final String role;
    private final String provisioningStatus;
    private final String name;
    private final String model;
    private final String brand;
    private final String serialNumber;
    private final String universalProductCode;
    private final String internationalArticleNumber;
    private final String connectorPolicyId;
    private final String connectorDestinationId;
    private final String connectorDeviceId;
    private final String deviceSpecificKey;
    private final String macAddress;
    private final String parentControllerId;
    private final String classification;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant activatedAt;
    private final String hubNetworkMode;
    private final Map<String, String> metaData;
    private final Map<String, String> tags;

    private GetManagedThingResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.owner = builder.owner;
        this.credentialLockerId = builder.credentialLockerId;
        this.advertisedProductId = builder.advertisedProductId;
        this.role = builder.role;
        this.provisioningStatus = builder.provisioningStatus;
        this.name = builder.name;
        this.model = builder.model;
        this.brand = builder.brand;
        this.serialNumber = builder.serialNumber;
        this.universalProductCode = builder.universalProductCode;
        this.internationalArticleNumber = builder.internationalArticleNumber;
        this.connectorPolicyId = builder.connectorPolicyId;
        this.connectorDestinationId = builder.connectorDestinationId;
        this.connectorDeviceId = builder.connectorDeviceId;
        this.deviceSpecificKey = builder.deviceSpecificKey;
        this.macAddress = builder.macAddress;
        this.parentControllerId = builder.parentControllerId;
        this.classification = builder.classification;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.activatedAt = builder.activatedAt;
        this.hubNetworkMode = builder.hubNetworkMode;
        this.metaData = builder.metaData;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String owner() {
        return this.owner;
    }

    public final String credentialLockerId() {
        return this.credentialLockerId;
    }

    public final String advertisedProductId() {
        return this.advertisedProductId;
    }

    public final Role role() {
        return Role.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final ProvisioningStatus provisioningStatus() {
        return ProvisioningStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final String name() {
        return this.name;
    }

    public final String model() {
        return this.model;
    }

    public final String brand() {
        return this.brand;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String universalProductCode() {
        return this.universalProductCode;
    }

    public final String internationalArticleNumber() {
        return this.internationalArticleNumber;
    }

    @Deprecated
    public final String connectorPolicyId() {
        return this.connectorPolicyId;
    }

    public final String connectorDestinationId() {
        return this.connectorDestinationId;
    }

    public final String connectorDeviceId() {
        return this.connectorDeviceId;
    }

    public final String deviceSpecificKey() {
        return this.deviceSpecificKey;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String parentControllerId() {
        return this.parentControllerId;
    }

    public final String classification() {
        return this.classification;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant activatedAt() {
        return this.activatedAt;
    }

    public final HubNetworkMode hubNetworkMode() {
        return HubNetworkMode.fromValue(this.hubNetworkMode);
    }

    public final String hubNetworkModeAsString() {
        return this.hubNetworkMode;
    }

    public final boolean hasMetaData() {
        return this.metaData != null && !(this.metaData instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metaData() {
        return this.metaData;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialLockerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.advertisedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.brand());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.universalProductCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.internationalArticleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDestinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSpecificKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentControllerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.activatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubNetworkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetaData() ? this.metaData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingResponse)) {
            return false;
        }
        GetManagedThingResponse other = (GetManagedThingResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.credentialLockerId(), other.credentialLockerId()) && Objects.equals(this.advertisedProductId(), other.advertisedProductId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.brand(), other.brand()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.universalProductCode(), other.universalProductCode()) && Objects.equals(this.internationalArticleNumber(), other.internationalArticleNumber()) && Objects.equals(this.connectorPolicyId(), other.connectorPolicyId()) && Objects.equals(this.connectorDestinationId(), other.connectorDestinationId()) && Objects.equals(this.connectorDeviceId(), other.connectorDeviceId()) && Objects.equals(this.deviceSpecificKey(), other.deviceSpecificKey()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.parentControllerId(), other.parentControllerId()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.activatedAt(), other.activatedAt()) && Objects.equals(this.hubNetworkModeAsString(), other.hubNetworkModeAsString()) && this.hasMetaData() == other.hasMetaData() && Objects.equals(this.metaData(), other.metaData()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedThingResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Owner", (Object)(this.owner() == null ? null : "*** Sensitive Data Redacted ***")).add("CredentialLockerId", (Object)this.credentialLockerId()).add("AdvertisedProductId", (Object)this.advertisedProductId()).add("Role", (Object)this.roleAsString()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("Name", (Object)this.name()).add("Model", (Object)(this.model() == null ? null : "*** Sensitive Data Redacted ***")).add("Brand", (Object)(this.brand() == null ? null : "*** Sensitive Data Redacted ***")).add("SerialNumber", (Object)(this.serialNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("UniversalProductCode", (Object)(this.universalProductCode() == null ? null : "*** Sensitive Data Redacted ***")).add("InternationalArticleNumber", (Object)(this.internationalArticleNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectorPolicyId", (Object)this.connectorPolicyId()).add("ConnectorDestinationId", (Object)this.connectorDestinationId()).add("ConnectorDeviceId", (Object)(this.connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")).add("DeviceSpecificKey", (Object)(this.deviceSpecificKey() == null ? null : "*** Sensitive Data Redacted ***")).add("MacAddress", (Object)(this.macAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("ParentControllerId", (Object)this.parentControllerId()).add("Classification", (Object)(this.classification() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ActivatedAt", (Object)this.activatedAt()).add("HubNetworkMode", (Object)this.hubNetworkModeAsString()).add("MetaData", this.hasMetaData() ? this.metaData() : null).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CredentialLockerId": {
                return Optional.ofNullable(clazz.cast(this.credentialLockerId()));
            }
            case "AdvertisedProductId": {
                return Optional.ofNullable(clazz.cast(this.advertisedProductId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brand()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "UniversalProductCode": {
                return Optional.ofNullable(clazz.cast(this.universalProductCode()));
            }
            case "InternationalArticleNumber": {
                return Optional.ofNullable(clazz.cast(this.internationalArticleNumber()));
            }
            case "ConnectorPolicyId": {
                return Optional.ofNullable(clazz.cast(this.connectorPolicyId()));
            }
            case "ConnectorDestinationId": {
                return Optional.ofNullable(clazz.cast(this.connectorDestinationId()));
            }
            case "ConnectorDeviceId": {
                return Optional.ofNullable(clazz.cast(this.connectorDeviceId()));
            }
            case "DeviceSpecificKey": {
                return Optional.ofNullable(clazz.cast(this.deviceSpecificKey()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "ParentControllerId": {
                return Optional.ofNullable(clazz.cast(this.parentControllerId()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "ActivatedAt": {
                return Optional.ofNullable(clazz.cast(this.activatedAt()));
            }
            case "HubNetworkMode": {
                return Optional.ofNullable(clazz.cast(this.hubNetworkModeAsString()));
            }
            case "MetaData": {
                return Optional.ofNullable(clazz.cast(this.metaData()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CredentialLockerId", CREDENTIAL_LOCKER_ID_FIELD);
        map.put("AdvertisedProductId", ADVERTISED_PRODUCT_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("UniversalProductCode", UNIVERSAL_PRODUCT_CODE_FIELD);
        map.put("InternationalArticleNumber", INTERNATIONAL_ARTICLE_NUMBER_FIELD);
        map.put("ConnectorPolicyId", CONNECTOR_POLICY_ID_FIELD);
        map.put("ConnectorDestinationId", CONNECTOR_DESTINATION_ID_FIELD);
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("DeviceSpecificKey", DEVICE_SPECIFIC_KEY_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("ParentControllerId", PARENT_CONTROLLER_ID_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ActivatedAt", ACTIVATED_AT_FIELD);
        map.put("HubNetworkMode", HUB_NETWORK_MODE_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingResponse, T> g) {
        return obj -> g.apply((GetManagedThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String owner;
        private String credentialLockerId;
        private String advertisedProductId;
        private String role;
        private String provisioningStatus;
        private String name;
        private String model;
        private String brand;
        private String serialNumber;
        private String universalProductCode;
        private String internationalArticleNumber;
        private String connectorPolicyId;
        private String connectorDestinationId;
        private String connectorDeviceId;
        private String deviceSpecificKey;
        private String macAddress;
        private String parentControllerId;
        private String classification;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant activatedAt;
        private String hubNetworkMode;
        private Map<String, String> metaData = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.owner(model.owner);
            this.credentialLockerId(model.credentialLockerId);
            this.advertisedProductId(model.advertisedProductId);
            this.role(model.role);
            this.provisioningStatus(model.provisioningStatus);
            this.name(model.name);
            this.model(model.model);
            this.brand(model.brand);
            this.serialNumber(model.serialNumber);
            this.universalProductCode(model.universalProductCode);
            this.internationalArticleNumber(model.internationalArticleNumber);
            this.connectorPolicyId(model.connectorPolicyId);
            this.connectorDestinationId(model.connectorDestinationId);
            this.connectorDeviceId(model.connectorDeviceId);
            this.deviceSpecificKey(model.deviceSpecificKey);
            this.macAddress(model.macAddress);
            this.parentControllerId(model.parentControllerId);
            this.classification(model.classification);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.activatedAt(model.activatedAt);
            this.hubNetworkMode(model.hubNetworkMode);
            this.metaData(model.metaData);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getCredentialLockerId() {
            return this.credentialLockerId;
        }

        public final void setCredentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
        }

        @Override
        public final Builder credentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
            return this;
        }

        public final String getAdvertisedProductId() {
            return this.advertisedProductId;
        }

        public final void setAdvertisedProductId(String advertisedProductId) {
            this.advertisedProductId = advertisedProductId;
        }

        @Override
        public final Builder advertisedProductId(String advertisedProductId) {
            this.advertisedProductId = advertisedProductId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(ProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getUniversalProductCode() {
            return this.universalProductCode;
        }

        public final void setUniversalProductCode(String universalProductCode) {
            this.universalProductCode = universalProductCode;
        }

        @Override
        public final Builder universalProductCode(String universalProductCode) {
            this.universalProductCode = universalProductCode;
            return this;
        }

        public final String getInternationalArticleNumber() {
            return this.internationalArticleNumber;
        }

        public final void setInternationalArticleNumber(String internationalArticleNumber) {
            this.internationalArticleNumber = internationalArticleNumber;
        }

        @Override
        public final Builder internationalArticleNumber(String internationalArticleNumber) {
            this.internationalArticleNumber = internationalArticleNumber;
            return this;
        }

        @Deprecated
        public final String getConnectorPolicyId() {
            return this.connectorPolicyId;
        }

        @Deprecated
        public final void setConnectorPolicyId(String connectorPolicyId) {
            this.connectorPolicyId = connectorPolicyId;
        }

        @Override
        @Deprecated
        public final Builder connectorPolicyId(String connectorPolicyId) {
            this.connectorPolicyId = connectorPolicyId;
            return this;
        }

        public final String getConnectorDestinationId() {
            return this.connectorDestinationId;
        }

        public final void setConnectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
        }

        @Override
        public final Builder connectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
            return this;
        }

        public final String getConnectorDeviceId() {
            return this.connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getDeviceSpecificKey() {
            return this.deviceSpecificKey;
        }

        public final void setDeviceSpecificKey(String deviceSpecificKey) {
            this.deviceSpecificKey = deviceSpecificKey;
        }

        @Override
        public final Builder deviceSpecificKey(String deviceSpecificKey) {
            this.deviceSpecificKey = deviceSpecificKey;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getParentControllerId() {
            return this.parentControllerId;
        }

        public final void setParentControllerId(String parentControllerId) {
            this.parentControllerId = parentControllerId;
        }

        @Override
        public final Builder parentControllerId(String parentControllerId) {
            this.parentControllerId = parentControllerId;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getActivatedAt() {
            return this.activatedAt;
        }

        public final void setActivatedAt(Instant activatedAt) {
            this.activatedAt = activatedAt;
        }

        @Override
        public final Builder activatedAt(Instant activatedAt) {
            this.activatedAt = activatedAt;
            return this;
        }

        public final String getHubNetworkMode() {
            return this.hubNetworkMode;
        }

        public final void setHubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
        }

        @Override
        public final Builder hubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
            return this;
        }

        @Override
        public final Builder hubNetworkMode(HubNetworkMode hubNetworkMode) {
            this.hubNetworkMode(hubNetworkMode == null ? null : hubNetworkMode.toString());
            return this;
        }

        public final Map<String, String> getMetaData() {
            if (this.metaData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metaData;
        }

        public final void setMetaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
        }

        @Override
        public final Builder metaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetManagedThingResponse build() {
            return new GetManagedThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedThingResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder owner(String var1);

        public Builder credentialLockerId(String var1);

        public Builder advertisedProductId(String var1);

        public Builder role(String var1);

        public Builder role(Role var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(ProvisioningStatus var1);

        public Builder name(String var1);

        public Builder model(String var1);

        public Builder brand(String var1);

        public Builder serialNumber(String var1);

        public Builder universalProductCode(String var1);

        public Builder internationalArticleNumber(String var1);

        @Deprecated
        public Builder connectorPolicyId(String var1);

        public Builder connectorDestinationId(String var1);

        public Builder connectorDeviceId(String var1);

        public Builder deviceSpecificKey(String var1);

        public Builder macAddress(String var1);

        public Builder parentControllerId(String var1);

        public Builder classification(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder activatedAt(Instant var1);

        public Builder hubNetworkMode(String var1);

        public Builder hubNetworkMode(HubNetworkMode var1);

        public Builder metaData(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);
    }
}

