/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttribute;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttributesCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCommandsCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportEventsCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportGeneratedCommandsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatterCapabilityReportCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatterCapabilityReportCluster> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::id)).setter(MatterCapabilityReportCluster.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("revision").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::revision)).setter(MatterCapabilityReportCluster.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> PUBLIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicId").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::publicId)).setter(MatterCapabilityReportCluster.setter(Builder::publicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::name)).setter(MatterCapabilityReportCluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SPEC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("specVersion").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::specVersion)).setter(MatterCapabilityReportCluster.setter(Builder::specVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specVersion").build()}).build();
    private static final SdkField<List<MatterCapabilityReportAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::attributes)).setter(MatterCapabilityReportCluster.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatterCapabilityReportAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commands").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::commands)).setter(MatterCapabilityReportCluster.setter(Builder::commands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::events)).setter(MatterCapabilityReportCluster.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> FEATURE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("featureMap").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::featureMap)).setter(MatterCapabilityReportCluster.setter(Builder::featureMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureMap").build()}).build();
    private static final SdkField<List<String>> GENERATED_COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generatedCommands").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::generatedCommands)).setter(MatterCapabilityReportCluster.setter(Builder::generatedCommands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedCommands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> FABRIC_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fabricIndex").getter(MatterCapabilityReportCluster.getter(MatterCapabilityReportCluster::fabricIndex)).setter(MatterCapabilityReportCluster.setter(Builder::fabricIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fabricIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REVISION_FIELD, PUBLIC_ID_FIELD, NAME_FIELD, SPEC_VERSION_FIELD, ATTRIBUTES_FIELD, COMMANDS_FIELD, EVENTS_FIELD, FEATURE_MAP_FIELD, GENERATED_COMMANDS_FIELD, FABRIC_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatterCapabilityReportCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Integer revision;
    private final String publicId;
    private final String name;
    private final String specVersion;
    private final List<MatterCapabilityReportAttribute> attributes;
    private final List<String> commands;
    private final List<String> events;
    private final Long featureMap;
    private final List<String> generatedCommands;
    private final Integer fabricIndex;

    private MatterCapabilityReportCluster(BuilderImpl builder) {
        this.id = builder.id;
        this.revision = builder.revision;
        this.publicId = builder.publicId;
        this.name = builder.name;
        this.specVersion = builder.specVersion;
        this.attributes = builder.attributes;
        this.commands = builder.commands;
        this.events = builder.events;
        this.featureMap = builder.featureMap;
        this.generatedCommands = builder.generatedCommands;
        this.fabricIndex = builder.fabricIndex;
    }

    public final String id() {
        return this.id;
    }

    public final Integer revision() {
        return this.revision;
    }

    public final String publicId() {
        return this.publicId;
    }

    public final String name() {
        return this.name;
    }

    public final String specVersion() {
        return this.specVersion;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<MatterCapabilityReportAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasCommands() {
        return this.commands != null && !(this.commands instanceof SdkAutoConstructList);
    }

    public final List<String> commands() {
        return this.commands;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<String> events() {
        return this.events;
    }

    public final Long featureMap() {
        return this.featureMap;
    }

    public final boolean hasGeneratedCommands() {
        return this.generatedCommands != null && !(this.generatedCommands instanceof SdkAutoConstructList);
    }

    public final List<String> generatedCommands() {
        return this.generatedCommands;
    }

    public final Integer fabricIndex() {
        return this.fabricIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.specVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommands() ? this.commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.featureMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedCommands() ? this.generatedCommands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fabricIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCapabilityReportCluster)) {
            return false;
        }
        MatterCapabilityReportCluster other = (MatterCapabilityReportCluster)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.publicId(), other.publicId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.specVersion(), other.specVersion()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasCommands() == other.hasCommands() && Objects.equals(this.commands(), other.commands()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.featureMap(), other.featureMap()) && this.hasGeneratedCommands() == other.hasGeneratedCommands() && Objects.equals(this.generatedCommands(), other.generatedCommands()) && Objects.equals(this.fabricIndex(), other.fabricIndex());
    }

    public final String toString() {
        return ToString.builder((String)"MatterCapabilityReportCluster").add("Id", (Object)this.id()).add("Revision", (Object)this.revision()).add("PublicId", (Object)this.publicId()).add("Name", (Object)this.name()).add("SpecVersion", (Object)this.specVersion()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Commands", this.hasCommands() ? this.commands() : null).add("Events", this.hasEvents() ? this.events() : null).add("FeatureMap", (Object)this.featureMap()).add("GeneratedCommands", this.hasGeneratedCommands() ? this.generatedCommands() : null).add("FabricIndex", (Object)this.fabricIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "publicId": {
                return Optional.ofNullable(clazz.cast(this.publicId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "specVersion": {
                return Optional.ofNullable(clazz.cast(this.specVersion()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "featureMap": {
                return Optional.ofNullable(clazz.cast(this.featureMap()));
            }
            case "generatedCommands": {
                return Optional.ofNullable(clazz.cast(this.generatedCommands()));
            }
            case "fabricIndex": {
                return Optional.ofNullable(clazz.cast(this.fabricIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("publicId", PUBLIC_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("specVersion", SPEC_VERSION_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("commands", COMMANDS_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("featureMap", FEATURE_MAP_FIELD);
        map.put("generatedCommands", GENERATED_COMMANDS_FIELD);
        map.put("fabricIndex", FABRIC_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCapabilityReportCluster, T> g) {
        return obj -> g.apply((MatterCapabilityReportCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Integer revision;
        private String publicId;
        private String name;
        private String specVersion;
        private List<MatterCapabilityReportAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> commands = DefaultSdkAutoConstructList.getInstance();
        private List<String> events = DefaultSdkAutoConstructList.getInstance();
        private Long featureMap;
        private List<String> generatedCommands = DefaultSdkAutoConstructList.getInstance();
        private Integer fabricIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCapabilityReportCluster model) {
            this.id(model.id);
            this.revision(model.revision);
            this.publicId(model.publicId);
            this.name(model.name);
            this.specVersion(model.specVersion);
            this.attributes(model.attributes);
            this.commands(model.commands);
            this.events(model.events);
            this.featureMap(model.featureMap);
            this.generatedCommands(model.generatedCommands);
            this.fabricIndex(model.fabricIndex);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final String getPublicId() {
            return this.publicId;
        }

        public final void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public final Builder publicId(String publicId) {
            this.publicId = publicId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSpecVersion() {
            return this.specVersion;
        }

        public final void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        @Override
        public final Builder specVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public final List<MatterCapabilityReportAttribute.Builder> getAttributes() {
            List<MatterCapabilityReportAttribute.Builder> result = MatterCapabilityReportAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<MatterCapabilityReportAttribute.BuilderImpl> attributes) {
            this.attributes = MatterCapabilityReportAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<MatterCapabilityReportAttribute> attributes) {
            this.attributes = MatterCapabilityReportAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(MatterCapabilityReportAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<MatterCapabilityReportAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (MatterCapabilityReportAttribute)((MatterCapabilityReportAttribute.Builder)MatterCapabilityReportAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCommands() {
            if (this.commands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commands;
        }

        public final void setCommands(Collection<String> commands) {
            this.commands = MatterCapabilityReportCommandsCopier.copy(commands);
        }

        @Override
        public final Builder commands(Collection<String> commands) {
            this.commands = MatterCapabilityReportCommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(String ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        public final Collection<String> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = MatterCapabilityReportEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = MatterCapabilityReportEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final Long getFeatureMap() {
            return this.featureMap;
        }

        public final void setFeatureMap(Long featureMap) {
            this.featureMap = featureMap;
        }

        @Override
        public final Builder featureMap(Long featureMap) {
            this.featureMap = featureMap;
            return this;
        }

        public final Collection<String> getGeneratedCommands() {
            if (this.generatedCommands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.generatedCommands;
        }

        public final void setGeneratedCommands(Collection<String> generatedCommands) {
            this.generatedCommands = MatterCapabilityReportGeneratedCommandsCopier.copy(generatedCommands);
        }

        @Override
        public final Builder generatedCommands(Collection<String> generatedCommands) {
            this.generatedCommands = MatterCapabilityReportGeneratedCommandsCopier.copy(generatedCommands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCommands(String ... generatedCommands) {
            this.generatedCommands(Arrays.asList(generatedCommands));
            return this;
        }

        public final Integer getFabricIndex() {
            return this.fabricIndex;
        }

        public final void setFabricIndex(Integer fabricIndex) {
            this.fabricIndex = fabricIndex;
        }

        @Override
        public final Builder fabricIndex(Integer fabricIndex) {
            this.fabricIndex = fabricIndex;
            return this;
        }

        public MatterCapabilityReportCluster build() {
            return new MatterCapabilityReportCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatterCapabilityReportCluster> {
        public Builder id(String var1);

        public Builder revision(Integer var1);

        public Builder publicId(String var1);

        public Builder name(String var1);

        public Builder specVersion(String var1);

        public Builder attributes(Collection<MatterCapabilityReportAttribute> var1);

        public Builder attributes(MatterCapabilityReportAttribute ... var1);

        public Builder attributes(Consumer<MatterCapabilityReportAttribute.Builder> ... var1);

        public Builder commands(Collection<String> var1);

        public Builder commands(String ... var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder featureMap(Long var1);

        public Builder generatedCommands(Collection<String> var1);

        public Builder generatedCommands(String ... var1);

        public Builder fabricIndex(Integer var1);
    }
}

