/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionVisibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaVersionListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaVersionListItem> {
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaId").getter(SchemaVersionListItem.getter(SchemaVersionListItem::schemaId)).setter(SchemaVersionListItem.setter(Builder::schemaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SchemaVersionListItem.getter(SchemaVersionListItem::typeAsString)).setter(SchemaVersionListItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SchemaVersionListItem.getter(SchemaVersionListItem::description)).setter(SchemaVersionListItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(SchemaVersionListItem.getter(SchemaVersionListItem::namespace)).setter(SchemaVersionListItem.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(SchemaVersionListItem.getter(SchemaVersionListItem::semanticVersion)).setter(SchemaVersionListItem.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticVersion").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(SchemaVersionListItem.getter(SchemaVersionListItem::visibilityAsString)).setter(SchemaVersionListItem.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, NAMESPACE_FIELD, SEMANTIC_VERSION_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaVersionListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String schemaId;
    private final String type;
    private final String description;
    private final String namespace;
    private final String semanticVersion;
    private final String visibility;

    private SchemaVersionListItem(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.type = builder.type;
        this.description = builder.description;
        this.namespace = builder.namespace;
        this.semanticVersion = builder.semanticVersion;
        this.visibility = builder.visibility;
    }

    public final String schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final SchemaVersionVisibility visibility() {
        return SchemaVersionVisibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaVersionListItem)) {
            return false;
        }
        SchemaVersionListItem other = (SchemaVersionListItem)obj;
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaVersionListItem").add("SchemaId", (Object)this.schemaId()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Namespace", (Object)this.namespace()).add("SemanticVersion", (Object)this.semanticVersion()).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SemanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaVersionListItem, T> g) {
        return obj -> g.apply((SchemaVersionListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaId;
        private String type;
        private String description;
        private String namespace;
        private String semanticVersion;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaVersionListItem model) {
            this.schemaId(model.schemaId);
            this.type(model.type);
            this.description(model.description);
            this.namespace(model.namespace);
            this.semanticVersion(model.semanticVersion);
            this.visibility(model.visibility);
        }

        public final String getSchemaId() {
            return this.schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(SchemaVersionVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public SchemaVersionListItem build() {
            return new SchemaVersionListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaVersionListItem> {
        public Builder schemaId(String var1);

        public Builder type(String var1);

        public Builder type(SchemaVersionType var1);

        public Builder description(String var1);

        public Builder namespace(String var1);

        public Builder semanticVersion(String var1);

        public Builder visibility(String var1);

        public Builder visibility(SchemaVersionVisibility var1);
    }
}

