/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyDerivationFunction {
    NIST_SP800("NIST_SP800"),
    ANSI_X963("ANSI_X963"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyDerivationFunction> VALUE_MAP;
    private final String value;

    private KeyDerivationFunction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyDerivationFunction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyDerivationFunction> knownValues() {
        EnumSet<KeyDerivationFunction> knownValues = EnumSet.allOf(KeyDerivationFunction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyDerivationFunction.class, KeyDerivationFunction::toString);
    }
}

