/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementClient;
import software.amazon.awssdk.services.snowdevicemanagement.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ResourceSummary;

public class ListDeviceResourcesIterable
implements SdkIterable<ListDeviceResourcesResponse> {
    private final SnowDeviceManagementClient client;
    private final ListDeviceResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceResourcesIterable(SnowDeviceManagementClient client, ListDeviceResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeviceResourcesResponseFetcher();
    }

    public Iterator<ListDeviceResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceSummary> resources() {
        Function<ListDeviceResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeviceResourcesResponseFetcher
    implements SyncPageFetcher<ListDeviceResourcesResponse> {
        private ListDeviceResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceResourcesResponse nextPage(ListDeviceResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceResourcesIterable.this.client.listDeviceResources(ListDeviceResourcesIterable.this.firstRequest);
            }
            return ListDeviceResourcesIterable.this.client.listDeviceResources((ListDeviceResourcesRequest)((Object)ListDeviceResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

