/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.bert;

import ai.djl.modality.nlp.bert.BertToken;
import ai.djl.modality.nlp.preprocess.SimpleTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BertTokenizer
extends SimpleTokenizer {
    private static final Pattern PATTERN = Pattern.compile("(\\S+?)([.,?!])?(\\s+|$)");

    @Override
    public List<String> tokenize(String input) {
        LinkedList<String> ret = new LinkedList<String>();
        Matcher m = PATTERN.matcher(input);
        while (m.find()) {
            ret.add(m.group(1));
            String token = m.group(2);
            if (token == null) continue;
            ret.add(token);
        }
        return ret;
    }

    public String tokenToString(List<String> tokens) {
        return String.join((CharSequence)" ", tokens);
    }

    public <E> List<E> pad(List<E> tokens, E padItem, int num) {
        if (tokens.size() >= num) {
            return tokens;
        }
        ArrayList<E> padded = new ArrayList<E>(num);
        padded.addAll(tokens);
        for (int i = tokens.size(); i < num; ++i) {
            padded.add(padItem);
        }
        return padded;
    }

    public BertToken encode(String question, String paragraph) {
        List<String> qToken = this.tokenize(question);
        List<String> pToken = this.tokenize(paragraph);
        int validLength = qToken.size() + pToken.size();
        qToken.add(0, "[CLS]");
        qToken.add("[SEP]");
        pToken.add("[SEP]");
        ArrayList<String> tokens = new ArrayList<String>(qToken);
        tokens.addAll(pToken);
        int tokenTypeStartIdx = qToken.size();
        long[] tokenTypeArr = new long[tokens.size()];
        Arrays.fill(tokenTypeArr, tokenTypeStartIdx, tokenTypeArr.length, 1L);
        long[] attentionMaskArr = new long[tokens.size()];
        Arrays.fill(attentionMaskArr, 1L);
        return new BertToken(tokens, Arrays.stream(tokenTypeArr).boxed().collect(Collectors.toList()), Arrays.stream(attentionMaskArr).boxed().collect(Collectors.toList()), validLength);
    }

    public BertToken encode(String question, String paragraph, int maxLength) {
        BertToken bertToken = this.encode(question, paragraph);
        return new BertToken(this.pad(bertToken.getTokens(), "[PAD]", maxLength), this.pad(bertToken.getTokenTypes(), 0L, maxLength), this.pad(bertToken.getAttentionMask(), 0L, maxLength), bertToken.getValidLength());
    }
}

