/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CaptchaDataset
extends RandomAccessDataset {
    private static final String ARTIFACT_ID = "captcha";
    private static final String VERSION = "1.1";
    public static final int IMAGE_WIDTH = 160;
    public static final int IMAGE_HEIGHT = 60;
    public static final int CAPTCHA_LENGTH = 6;
    public static final int CAPTCHA_OPTIONS = 11;
    private Dataset.Usage usage;
    private List<String> items;
    private Artifact.Item dataItem;
    private String pathPrefix;
    private MRL mrl;
    private boolean prepared;

    public CaptchaDataset(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Record get(NDManager manager, long index) throws IOException {
        String item = this.items.get(Math.toIntExact(index));
        Path imagePath = this.mrl.getRepository().getFile(this.dataItem, this.pathPrefix + '/' + item + ".jpeg");
        NDArray imageArray = ImageFactory.getInstance().fromFile(imagePath).toNDArray(manager, Image.Flag.GRAYSCALE);
        NDList data = new NDList(new NDArray[]{imageArray});
        NDList labels = new NDList(6);
        char[] labelChars = item.toCharArray();
        for (int i = 0; i < 6; ++i) {
            if (i < item.length()) {
                int labelDigit = Integer.parseInt(Character.toString(labelChars[i]));
                labels.add((Object)manager.create(labelDigit));
                continue;
            }
            labels.add((Object)manager.create(11));
        }
        return new Record(data, labels);
    }

    protected long availableSize() {
        return this.items.size();
    }

    public void prepare(Progress progress) throws IOException {
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        this.dataItem = (Artifact.Item)artifact.getFiles().get("data");
        this.pathPrefix = this.getUsagePath();
        this.items = new ArrayList<String>();
        for (String filenameWithExtension : this.mrl.getRepository().listDirectory(this.dataItem, this.pathPrefix)) {
            String captchaFilename = filenameWithExtension.substring(0, filenameWithExtension.lastIndexOf(46));
            this.items.add(captchaFilename);
        }
        this.prepared = true;
    }

    private String getUsagePath() {
        switch (this.usage) {
            case TRAIN: {
                return "train";
            }
            case TEST: {
                return "test";
            }
            case VALIDATION: {
                return "validate";
            }
        }
        throw new IllegalArgumentException("Invalid usage");
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "captcha";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
        }

        protected Builder self() {
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public CaptchaDataset build() {
            return new CaptchaDataset(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, CaptchaDataset.VERSION);
        }
    }
}

