/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.client.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.IAsyncBopClient;
import com.baiwang.bop.client.IBopClient;
import com.baiwang.bop.request.IBopRequest;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.respose.parser.impl.JsonResposeParser;
import com.baiwang.bop.respose.parser.impl.XmlResposeParser;
import com.baiwang.bop.utils.BopHashMap;
import com.baiwang.bop.utils.BopUtils;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;

public class BopRestClient
implements IBopClient,
IAsyncBopClient {
    private static final Logger LOG = Logger.getLogger(BopRestClient.class.toString());
    private static final String APP_KEY = "appKey";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "version";
    private static final String SIGN = "sign";
    private static final String SESSION = "token";
    private static final String TYPE = "type";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private WebUtils webUtils;

    private WebUtils getWebUtil() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils();
        }
        return this.webUtils;
    }

    public BopRestClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
        this.getWebUtil();
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort) {
        this.webUtils.setProxy(proxyHost, proxyPort);
    }

    @Override
    public void setAuthorization(String userName, String passWord) {
        this.webUtils.setAuthorization(userName, passWord);
    }

    public BopRestClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
        this.getWebUtil();
    }

    @Override
    public <T> T execute(IBopRequest request, String session, Class<T> respClazz) throws BopException {
        String rsp;
        String requestJson = JacksonUtil.beanToString(request);
        LOG.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        String postServerUrl = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "sync", null, requestJson);
        try {
            LOG.info("\u8bf7\u6c42url\uff1a" + postServerUrl);
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl, requestJson) : WebUtils.doPost(postServerUrl, requestJson);
            LOG.info("\u54cd\u5e94\u4fe1\u606f\uff1a" + rsp);
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        this.tryParseException(rsp);
        return this.getResposeParser(this.format, respClazz).parse(rsp, request.getApiName());
    }

    @Override
    public <T> T executeAsyn(IBopRequest request, String session, Class<T> respClazz, Integer outTime) throws BopException {
        String rsp;
        int sleepTime = 100;
        int maxTime = outTime / sleepTime;
        String requestJson = JacksonUtil.beanToString(request);
        LOG.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        String postServerUrl1 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "asyn", null, requestJson);
        try {
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl1, requestJson) : WebUtils.doPost(postServerUrl1, requestJson);
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        String requestId = this.getRequestId(rsp);
        String postServerUrl2 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "result", requestId, ".");
        LOG.info("\u83b7\u53d6\u7ed3\u679c\u5730\u5740\uff1a" + postServerUrl2);
        int count = 1;
        try {
            while (true) {
                rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl2, ".") : WebUtils.doPost(postServerUrl2, ".");
                LOG.info("\u7b2c" + count + "\u6b21\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
                this.tryParseException(rsp);
                T responseBean = this.getResposeParser(this.format, respClazz).parse(rsp, request.getApiName());
                if (null != responseBean) {
                    return responseBean;
                }
                if (++count > maxTime) {
                    LOG.info("\u54cd\u5e94\u8d85\u65f6...");
                    throw new BopException("system.error", "time out!");
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    @Override
    public String sendRequest(IBopRequest request, String session) throws BopException {
        String rsp;
        String requestJson = JacksonUtil.beanToString(request);
        LOG.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestJson);
        String postServerUrl1 = this.appendSystemParamsToUrl(this.serverUrl, request.getApiName(), session, "asyn", null, requestJson);
        LOG.info("\u8bf7\u6c42\u5730\u5740\uff1a" + postServerUrl1);
        try {
            rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl1, requestJson) : WebUtils.doPost(postServerUrl1, requestJson);
        }
        catch (IOException e) {
            throw new BopException(e);
        }
        LOG.info("\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
        this.tryParseException(rsp);
        String requestId = this.getRequestId(rsp);
        LOG.info("\u8bf7\u6c42id\uff1a" + requestId);
        return requestId;
    }

    @Override
    public <T> T getResponse(String requestId, String session, Class<T> respClazz, String requestApiName) throws BopException {
        T responseBean;
        String postServerUrl2 = this.appendSystemParamsToUrl(this.serverUrl, requestApiName, session, "result", requestId, ".");
        LOG.info("\u83b7\u53d6\u7ed3\u679c\u5730\u5740\uff1a" + postServerUrl2);
        try {
            String rsp = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(postServerUrl2, ".") : WebUtils.doPost(postServerUrl2, ".");
            LOG.info("\u54cd\u5e94\u7ed3\u679c\uff1a" + rsp);
            this.tryParseException(rsp);
            responseBean = this.getResposeParser(this.format, respClazz).parse(rsp, requestApiName);
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return responseBean;
    }

    private <T> IBopResposeParser<T> getResposeParser(String format, Class<T> clazz) {
        if (format.equals("xml")) {
            return new XmlResposeParser<T>(clazz);
        }
        return new JsonResposeParser<T>(clazz);
    }

    private void tryParseException(String rsp) throws BopException {
        if ("json".equals(this.format)) {
            BopUtils.tryParseException(rsp);
        } else {
            BopUtils.tryParseXmlException(rsp);
        }
    }

    private String getRequestId(String rsp) throws BopException {
        if ("json".equals(this.format)) {
            return BopUtils.getJsonRequestId(rsp);
        }
        return BopUtils.getXmlRequestId(rsp);
    }

    private void appendSystemParams(BopHashMap textParams, String apiName, String session, String body) {
        textParams.put(METHOD, apiName);
        textParams.put(VERSION, "5.0");
        textParams.put(APP_KEY, this.appKey);
        textParams.put(FORMAT, this.format);
        textParams.put(TIMESTAMP, (Object)new Date());
        textParams.put(SESSION, session);
        try {
            textParams.put(SIGN, BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    private String appendSystemParamsToUrl(String url, String apiName, String session, String type, String asynId, String body) {
        Long time = new Date().getTime();
        StringBuilder sburl = new StringBuilder(url);
        sburl.append("?");
        sburl.append(METHOD);
        sburl.append("=");
        sburl.append(apiName);
        sburl.append("&");
        sburl.append(VERSION);
        sburl.append("=5.0&");
        sburl.append(APP_KEY);
        sburl.append("=");
        sburl.append(this.appKey);
        sburl.append("&");
        sburl.append(FORMAT);
        sburl.append("=");
        sburl.append(this.format);
        sburl.append("&");
        sburl.append(TIMESTAMP);
        sburl.append("=");
        sburl.append(time);
        sburl.append("&");
        sburl.append(SESSION);
        sburl.append("=");
        sburl.append(session);
        sburl.append("&");
        sburl.append(TYPE);
        sburl.append("=");
        sburl.append(type);
        if (asynId != null) {
            sburl.append("&");
            sburl.append("asynRequestId");
            sburl.append("=");
            sburl.append(asynId);
        }
        try {
            BopHashMap textParams = new BopHashMap();
            textParams.put(METHOD, apiName);
            textParams.put(VERSION, "5.0");
            textParams.put(APP_KEY, this.appKey);
            textParams.put(FORMAT, this.format);
            textParams.put(TIMESTAMP, (Object)time);
            textParams.put(SESSION, session);
            textParams.put(TYPE, type);
            if (asynId != null) {
                textParams.put("asynRequestId", asynId);
            }
            sburl.append("&");
            sburl.append(SIGN);
            sburl.append("=");
            sburl.append(BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BopException(e);
        }
        return sburl.toString();
    }
}

