/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.client.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.client.ILoginClient;
import com.baiwang.bop.request.impl.LoginRequest;
import com.baiwang.bop.respose.entity.LoginResponse;
import com.baiwang.bop.respose.parser.impl.JsonResposeParser;
import com.baiwang.bop.utils.BopUtils;
import com.baiwang.bop.utils.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;

public class PostLogin
implements ILoginClient {
    private String url;
    private static final Logger log = Logger.getLogger(PostLogin.class.toString());
    private WebUtils webUtils;

    private WebUtils getWebUtil() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils();
        }
        return this.webUtils;
    }

    public PostLogin(String url) {
        this.url = url;
        this.getWebUtil();
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort) {
        this.webUtils.setProxy(proxyHost, proxyPort);
    }

    @Override
    public void setAuthorization(String userName, String passWord) {
        this.webUtils.setAuthorization(userName, passWord);
    }

    @Override
    public LoginResponse login(LoginRequest loginRequest) throws BopException {
        try {
            String loginUrl = this.url + "?" + WebUtils.buildQuery(loginRequest.getTextParams(), "UTF-8");
            log.info("\u8bf7\u6c42url\uff1a" + loginUrl);
            String result = null;
            result = WebUtils.isHttps(this.url) ? WebUtils.doPostHttps(loginUrl, ".") : WebUtils.doPost(loginUrl, ".");
            log.info("\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            BopUtils.tryParseException(result);
            JsonResposeParser<LoginResponse> parser = new JsonResposeParser<LoginResponse>(LoginResponse.class);
            LoginResponse loginResponse = (LoginResponse)parser.parse(result, loginRequest.getApiName());
            return loginResponse;
        }
        catch (IOException e) {
            throw new BopException(e);
        }
    }

    @Override
    public LoginResponse refreshToken(String clientId, String clientSecret, String refreshValue) throws BopException {
        try {
            String refreshTokenUrl = this.url + "?version=" + "5.0" + "&grant_type=refresh_token&refresh_token=" + refreshValue + "&client_id=" + clientId + "&client_secret=" + clientSecret + "&method=baiwang.oauth.token&timestamp=" + new Date().getTime();
            log.info("\u5237\u65b0url\uff1a" + refreshTokenUrl);
            String result = null;
            result = WebUtils.isHttps(this.url) ? WebUtils.doPostHttps(refreshTokenUrl, ".") : WebUtils.doPost(refreshTokenUrl, ".");
            log.info("\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            BopUtils.tryParseException(result);
            JsonResposeParser<LoginResponse> parser = new JsonResposeParser<LoginResponse>(LoginResponse.class);
            LoginResponse loginResponse = (LoginResponse)parser.parse(result, "baiwang.oauth.token");
            return loginResponse;
        }
        catch (IOException e) {
            throw new BopException(e);
        }
    }
}

