/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.respose.parser.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.utils.JacksonUtil;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class JsonResposeParser<T>
implements IBopResposeParser<T> {
    private static final Logger log = Logger.getLogger(JsonResposeParser.class.toString());
    private static final String METHOD = "method";
    private static final String RESPONSE = "response";
    private Class<T> clazz;

    public JsonResposeParser(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T parse(String rsp, String api) throws BopException {
        try {
            ObjectNode respObj = JacksonUtil.getMapper().readValue(rsp, ObjectNode.class);
            if (respObj.has(METHOD) && respObj.get(METHOD).asText().equals(api)) {
                if ("null".equals(respObj.get(RESPONSE) + "")) {
                    return this.clazz.newInstance();
                }
                if (respObj.get(RESPONSE).isArray()) {
                    return this.parserToArray(respObj);
                }
                if (respObj.get(RESPONSE).get("content") != null && "pending".equals(respObj.get(RESPONSE).get("content").asText())) {
                    return null;
                }
                ObjectNode obj = (ObjectNode)respObj.get(RESPONSE);
                obj.set(METHOD, respObj.get(METHOD));
                obj.set("requestId", respObj.get("requestId"));
                return this.parserToObject(obj);
            }
            throw new BopException("the respose not in format");
        }
        catch (Exception e) {
            throw new BopException("system.error", rsp, e);
        }
    }

    private T parserToArray(ObjectNode respObj) {
        ArrayNode children = (ArrayNode)respObj.get(RESPONSE);
        ObjectNode node = JacksonUtil.getMapper().createObjectNode();
        Field[] properties = this.clazz.getDeclaredFields();
        for (int i = 0; i < properties.length; ++i) {
            if (!"interface java.util.List".equals(properties[i].getType() + "")) continue;
            node.set(properties[i].getName(), children);
        }
        node.set(METHOD, respObj.get(METHOD));
        node.set("requestId", respObj.get("requestId"));
        return this.parserToObject(node);
    }

    private T parserToObject(ObjectNode node) {
        T rtn = JacksonUtil.ObjectNodeToObject(node, this.clazz);
        if (null == rtn) {
            throw new BopException("the respose object not in format");
        }
        return rtn;
    }
}

