/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.respose.parser.impl;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.respose.parser.IBopResposeParser;
import com.baiwang.bop.utils.XmlUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlResposeParser<T>
implements IBopResposeParser<T> {
    private static final String METHOD = "method";
    private static final String RESPONSE = "response";
    private static String methodName;
    private static String requestIdNum;
    private static Element methodElement;
    private static Element requestIdElement;
    private Class<T> clazz;

    public XmlResposeParser(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T parse(String rsp, String api) throws BopException {
        try {
            Document document = DocumentHelper.parseText(rsp);
            Element root = document.getRootElement();
            methodName = root.elementText(METHOD);
            requestIdNum = root.elementText("requestId");
            requestIdElement = root.element("requestId");
            methodElement = root.element(METHOD);
            if (api.equals(methodName)) {
                if (root.element(RESPONSE) == null || "".equals(root.element(RESPONSE)) || "null".equals(root.element(RESPONSE))) {
                    return this.clazz.newInstance();
                }
                List<Element> rosponseElements = XmlUtil.getRosponseElements(root);
                if (rosponseElements.size() > 1 || this.isListBean(rosponseElements.get(0))) {
                    return this.parserToDirectList(rosponseElements);
                }
                Element responseElement = rosponseElements.get(0);
                if (XmlUtil.isList(responseElement)) {
                    return this.parserToArray(responseElement);
                }
                return this.parserToObject(responseElement);
            }
            throw new BopException("the respose not in format");
        }
        catch (Exception e) {
            throw new BopException(e);
        }
    }

    private boolean isListBean(Element rElement) {
        Field[] properties = this.clazz.getDeclaredFields();
        if (properties.length == 1 && "interface java.util.List".equals(properties[0].getType() + "")) {
            String qName = ((Element)rElement.elements().get(0)).getName();
            return !qName.equals(properties[0].getName());
        }
        return false;
    }

    private T parserToArray(Element root) {
        Element rootElement = DocumentHelper.createElement(this.clazz.getSimpleName());
        Field[] properties = this.clazz.getDeclaredFields();
        String sonNodeName = "null";
        for (int i = 0; i < properties.length; ++i) {
            if (!"interface java.util.List".equals(properties[i].getType() + "")) continue;
            sonNodeName = properties[i].getName();
        }
        StringBuilder sonElement = new StringBuilder("<" + sonNodeName + ">");
        List listElement = root.elements();
        for (Element e : listElement) {
            sonElement.append(e.asXML());
        }
        sonElement.append("</" + sonNodeName + ">");
        try {
            rootElement.add(DocumentHelper.parseText(sonElement.toString()).getRootElement());
        }
        catch (DocumentException e) {
            throw new BopException(e);
        }
        return this.parserToObject(rootElement);
    }

    private T parserToObject(Element root) {
        if (root.element("content") != null && "pending".equals(root.element("content").getText())) {
            return null;
        }
        root.add(methodElement);
        root.add(requestIdElement);
        T rtn = XmlUtil.getBean(root, this.clazz);
        if (null == rtn) {
            throw new BopException("the respose object not in format");
        }
        return rtn;
    }

    private T parserToDirectList(List<Element> list) {
        Element rootElement = DocumentHelper.createElement(this.clazz.getSimpleName());
        String sonNodeName = this.clazz.getDeclaredFields()[0].getName();
        StringBuilder sonElement = new StringBuilder("<" + sonNodeName + ">");
        for (int i = 0; i < list.size(); ++i) {
            sonElement.append(list.get(i).asXML());
        }
        sonElement.append("</" + sonNodeName + ">");
        try {
            rootElement.add(DocumentHelper.parseText(sonElement.toString()).getRootElement());
        }
        catch (DocumentException e) {
            throw new BopException(e);
        }
        return this.parserToObject(rootElement);
    }
}

