/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.utils;

import com.baiwang.bop.client.BopException;
import com.baiwang.bop.respose.entity.ErrorResponse;
import com.baiwang.bop.utils.Encrypt;
import com.baiwang.bop.utils.JacksonUtil;
import com.baiwang.bop.utils.StrUtils;
import com.baiwang.bop.utils.WebUtils;
import com.baiwang.bop.utils.XmlUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class BopUtils {
    private BopUtils() {
    }

    public static String signTopRequest(Map<String, String> params, String secret, String body) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        params.put("version", "3.0");
        params.put("token", "e65e2e65-b6df-415e-92ea-cace43537a63");
        params.put("timestamp", "1536581023275");
        body = "{\"companyName\":\"\u9707\u65e6\",\"accuracy\":\"false\"}";
        StringBuilder query = new StringBuilder();
        query.append(secret);
        for (String key : keys) {
            String value = params.get(key);
            if (StrUtils.isEmpty(key) || StrUtils.isEmpty(value)) continue;
            query.append(key).append(value);
        }
        body.replaceAll("\n", "");
        body.replaceAll("\t", "");
        body.replaceAll("\r", "");
        query.append(body);
        query.append(secret);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new BopException(ignored);
        }
        byte[] bytes = md5.digest(query.toString().getBytes("UTF-8"));
        StringBuilder sign = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        System.out.println(sign.toString());
        return sign.toString();
    }

    public static boolean verifyTopResponse(String topParams, String topSession, String topSign, String appKey, String appSecret) throws IOException {
        StringBuilder result = new StringBuilder();
        MessageDigest md5 = BopUtils.getMd5MessageDigest();
        result.append(appKey).append(topParams).append(topSession).append(appSecret);
        byte[] bytes = md5.digest(result.toString().getBytes("UTF-8"));
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(bytes).equals(topSign);
    }

    private static MessageDigest getMd5MessageDigest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Map<String, String> decodeTopParams(String params) throws IOException {
        return BopUtils.decodeTopParams(params, "UTF-8");
    }

    public static Map<String, String> decodeTopParams(String params, String charset) throws IOException {
        if (StrUtils.isEmpty(params)) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] buffer = decoder.decodeBuffer(params);
        String decodedParams = new String(buffer, charset);
        return WebUtils.splitUrlQuery(decodedParams);
    }

    public static String getSandboxSessionUrl(String authCode) {
        StringBuilder url = new StringBuilder("http://container.api.tbsandbox.com/container");
        url.append("?authcode=").append(authCode);
        return url.toString();
    }

    public static String getUuidPasswd(String passwd, String uuid) {
        if (!StrUtils.isEmpty(uuid)) {
            return Encrypt.md5AndSha(passwd + uuid);
        }
        return Encrypt.md5AndSha(passwd);
    }

    public static String getProductWebSessionUrl(String appKey) {
        StringBuilder url = new StringBuilder("http://container.open.taobao.com/container");
        url.append("?appkey=").append(appKey);
        return url.toString();
    }

    public static String getProductClientSessionUrl(String authCode) {
        StringBuilder url = new StringBuilder("http://container.open.taobao.com/container");
        url.append("?authcode=").append(authCode);
        return url.toString();
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = BopUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void tryParseException(String rsp) throws BopException {
        if (rsp.contains(",\"errorResponse\":{")) {
            try {
                Map rspJson = JacksonUtil.getMapper().readValue(rsp, Map.class);
                Map errJson = (Map)rspJson.get("errorResponse");
                String method = rspJson.get("method") + "";
                String requestId = rspJson.get("requestId") + "";
                String errCode = errJson.get("code") + "";
                String errMsg = errJson.get("message") + "";
                String subErrCode = errJson.get("subCode") + "";
                String subErrMsg = errJson.get("subMessage") + "";
                if (subErrCode == null && subErrMsg == null) {
                    throw new BopException(errCode, errMsg);
                }
                throw new BopException(method, requestId, errCode, errMsg, subErrCode, subErrMsg);
            }
            catch (IOException e) {
                throw new BopException(e);
            }
        }
    }

    public static void tryParseXmlException(String rsp) throws BopException {
        if (rsp.contains("<errorResponse>")) {
            try {
                Document document = DocumentHelper.parseText(rsp);
                Element root = document.getRootElement();
                Element errorResponseElement = root.element("errorResponse");
                ErrorResponse errorResponse = XmlUtil.getBean(errorResponseElement, ErrorResponse.class);
                String method = root.elementText("method");
                String requestId = root.elementText("requestId");
                String errCode = errorResponse.getCode();
                String errMsg = errorResponse.getMessage();
                String subErrCode = errorResponse.getSubCode();
                String subErrMsg = errorResponse.getSubMessage();
                if (StrUtils.isEmpty(subErrCode) && StrUtils.isEmpty(subErrMsg)) {
                    throw new BopException(errCode, errMsg);
                }
                throw new BopException(method, requestId, errCode, errMsg, subErrCode, subErrMsg);
            }
            catch (Exception e) {
                throw new BopException(e);
            }
        }
    }

    public static String getJsonRequestId(String rsp) {
        try {
            ObjectNode respObj = JacksonUtil.getMapper().readValue(rsp, ObjectNode.class);
            String id = respObj.get("requestId").asText();
            if (StrUtils.isEmpty(id)) {
                throw new BopException("Error returning information!");
            }
            return id;
        }
        catch (IOException e) {
            throw new BopException("system.error", rsp, e);
        }
    }

    public static String getXmlRequestId(String rsp) {
        try {
            Document document = DocumentHelper.parseText(rsp);
            Element root = document.getRootElement();
            String id = (String)root.element("requestId").getData();
            if (StrUtils.isEmpty(id)) {
                throw new BopException("Error returning information!");
            }
            return id;
        }
        catch (Exception e) {
            throw new BopException("system.error", rsp, e);
        }
    }
}

