/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.bop.utils;

import com.baiwang.bop.utils.Base64;
import com.baiwang.bop.utils.FileItem;
import com.baiwang.bop.utils.StrUtils;
import com.baiwang.bop.utils.myHostnameVerifier;
import com.baiwang.bop.utils.myX509TrustManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static String userName;
    private static String passWord;
    private static boolean authorization;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean hasProxy;

    public void setProxy(String proxyHost, int proxyPort) {
        WebUtils.proxyHost = proxyHost;
        WebUtils.proxyPort = proxyPort;
        hasProxy = true;
    }

    public void setAuthorization(String userName, String passWord) {
        WebUtils.userName = userName;
        WebUtils.passWord = passWord;
        authorization = true;
    }

    public static boolean isHttps(String url) {
        String urlToop = url.substring(0, 5);
        urlToop.toLowerCase();
        return "https".equals(urlToop);
    }

    public static String doPost(String url, Map<String, String> params) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET);
    }

    public static String doPost(String url, String params) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET);
    }

    public static String doPostHttps(String url, String params) throws IOException {
        return WebUtils.doPostHttps(url, params, DEFAULT_CHARSET);
    }

    public static String doPost(String url, String params, String charset) throws IOException {
        String ctype = "application/json;charset=" + charset;
        return WebUtils.doPost(url, ctype, params.getBytes(charset));
    }

    public static String doPostHttps(String url, String params, String charset) throws IOException {
        String ctype = "application/json;charset=" + charset;
        return WebUtils.doPostHttps(url, ctype, params.getBytes(charset));
    }

    public static String doPost(String url, Map<String, String> params, String charset) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        return WebUtils.doPost(url, ctype, query.getBytes(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> textParams, Map<String, FileItem> fileParams) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, textParams, DEFAULT_CHARSET);
        }
        return WebUtils.doPost(url, textParams, fileParams, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> textParams, Map<String, FileItem> fileParams, String charset) throws IOException {
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            String ctype = "multipart/form-data;charset=" + charset + ";boundary=" + boundary;
            conn = WebUtils.getConnection(new URL(url), METHOD_POST, ctype);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
            Set<Map.Entry<String, String>> textEntrySet = textParams.entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] byArray = WebUtils.getTextEntry(entry.getKey(), entry.getValue(), charset);
                out.write(entryBoundaryBytes);
                out.write(byArray);
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                byte[] fileBytes = WebUtils.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                out.write(entryBoundaryBytes);
                out.write(fileBytes);
                out.write(fileItem.getContent());
            }
            byte[] byArray = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
            out.write(byArray);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        String rsp;
        HttpURLConnection conn = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = WebUtils.buildQuery(params, charset);
            conn = WebUtils.getConnection(WebUtils.buildGetUrl(url, query), METHOD_GET, ctype);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGetHttps(String url, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            conn = WebUtils.getConnectionHttps(new URL(url), METHOD_GET, ctype);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostHttps(String url, String ctype, byte[] content) throws IOException {
        HttpsURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = WebUtils.getConnectionHttps(new URL(url), METHOD_POST, ctype);
            out = conn.getOutputStream();
            out.write(content);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostHttps1(String url, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            conn = WebUtils.getConnectionHttps(new URL(url), METHOD_GET, ctype);
            rsp = WebUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn;
        if (hasProxy) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (authorization) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encrypt(userName + ":" + passWord).replaceAll("\n", ""));
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setConnectTimeout(90000);
        conn.setReadTimeout(90000);
        return conn;
    }

    private static HttpsURLConnection getConnectionHttps(URL url, String method, String ctype) throws IOException {
        HttpsURLConnection conn;
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManager[] xtmArray = new X509TrustManager[]{new myX509TrustManager()};
            sslContext.init(null, xtmArray, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new myHostnameVerifier());
        if (hasProxy) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            conn = (HttpsURLConnection)url.openConnection(proxy);
            if (authorization) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encrypt(userName + ":" + passWord).replaceAll("\n", ""));
            }
        } else {
            conn = (HttpsURLConnection)url.openConnection();
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", ctype);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setConnectTimeout(90000);
        conn.setReadTimeout(90000);
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StrUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StrUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StrUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StrUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StrUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StrUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StrUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StrUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    static {
        authorization = false;
        hasProxy = false;
    }
}

