/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MllpDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

abstract class Hl7DecoderReader<T extends MllpDecoder>
implements HL7Reader {
    private InputStream in;
    private T decoder;
    private Charset charset;

    public Hl7DecoderReader() throws IOException {
        this.decoder = this.initDecoder();
    }

    public Hl7DecoderReader(InputStream in) throws IOException {
        this.setInputStream(in);
        this.decoder = this.initDecoder();
    }

    public Hl7DecoderReader(InputStream in, Charset charset) throws IOException {
        this.setInputStream(in);
        this.charset = charset;
        this.decoder = this.initDecoder();
    }

    protected abstract T initDecoder();

    protected Charset getCharset() {
        if (this.charset == null) {
            String charsetString = System.getProperty("ca.uhn.hl7v2.llp.charset", "US-ASCII");
            this.charset = charsetString.equals("default") ? Charset.defaultCharset() : Charset.forName(charsetString);
        }
        return this.charset;
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.in = new BufferedInputStream(in);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    public String getMessage() throws IOException, LLPException {
        return ((MllpDecoder)this.decoder).getMessage(this.in);
    }

    protected T getDecoder() {
        return this.decoder;
    }
}

