/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Field;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingMessageVisitor<T extends MessageVisitor>
implements MessageVisitor {
    private T delegate;
    protected static final Logger LOG = LoggerFactory.getLogger(DelegatingMessageVisitor.class);

    public DelegatingMessageVisitor(T delegate) {
        this.delegate = delegate;
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean start(Message message) throws HL7Exception {
        return this.delegate.start(message);
    }

    @Override
    public boolean end(Message message) throws HL7Exception {
        return this.delegate.end(message);
    }

    @Override
    public boolean start(Group group, Location location) throws HL7Exception {
        return this.delegate.start(group, location);
    }

    @Override
    public boolean end(Group group, Location location) throws HL7Exception {
        return this.delegate.end(group, location);
    }

    @Override
    public boolean start(Segment segment, Location location) throws HL7Exception {
        return this.delegate.start(segment, location);
    }

    @Override
    public boolean end(Segment segment, Location location) throws HL7Exception {
        return this.delegate.end(segment, location);
    }

    @Override
    public boolean start(Field field, Location location) throws HL7Exception {
        return this.delegate.start(field, location);
    }

    @Override
    public boolean end(Field Field2, Location location) throws HL7Exception {
        return this.delegate.end(Field2, location);
    }

    @Override
    public boolean start(Composite type, Location location) throws HL7Exception {
        return this.delegate.start(type, location);
    }

    @Override
    public boolean end(Composite type, Location location) throws HL7Exception {
        return this.delegate.end(type, location);
    }

    @Override
    public boolean visit(Primitive type, Location location) throws HL7Exception {
        return this.delegate.visit(type, location);
    }
}

