/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.util.ReadOnlyMessageIterator;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import java.util.ArrayList;
import java.util.Iterator;

public class OnlyKnownSegmentsRule
extends AbstractMessageRule {
    public static final MessageRule ONLY_KNOWN_SEGMENTS = new OnlyKnownSegmentsRule();

    @Override
    public ValidationException[] apply(Message msg) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        Iterator<Structure> iter = ReadOnlyMessageIterator.createPopulatedStructureIterator((Group)msg, GenericSegment.class);
        while (iter.hasNext()) {
            String segmentName = iter.next().getName();
            ValidationException ve = new ValidationException("Found unknown segment: " + segmentName);
            Location location = new Location().withSegmentName(segmentName);
            ve.setLocation(location);
            exceptions.add(ve);
        }
        return exceptions.toArray(new ValidationException[exceptions.size()]);
    }
}

