/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.LunarYear;
import com.nlf.calendar.NineStar;
import com.nlf.calendar.Solar;
import com.nlf.calendar.util.LunarUtil;
import java.util.List;

public class LunarMonth {
    private final int year;
    private final int month;
    private final int dayCount;
    private final double firstJulianDay;

    public LunarMonth(int lunarYear, int lunarMonth, int dayCount, double firstJulianDay) {
        this.year = lunarYear;
        this.month = lunarMonth;
        this.dayCount = dayCount;
        this.firstJulianDay = firstJulianDay;
    }

    public static LunarMonth fromYm(int lunarYear, int lunarMonth) {
        return LunarYear.fromYear(lunarYear).getMonth(lunarMonth);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isLeap() {
        return this.month < 0;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public double getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public String getPositionTaiSui() {
        String p;
        int m = Math.abs(this.month) % 4;
        switch (m) {
            case 0: {
                p = "\u5dfd";
                break;
            }
            case 1: {
                p = "\u826e";
                break;
            }
            case 3: {
                p = "\u5764";
                break;
            }
            default: {
                p = LunarUtil.POSITION_GAN[Solar.fromJulianDay(this.getFirstJulianDay()).getLunar().getMonthGanIndex()];
            }
        }
        return p;
    }

    public String getPositionTaiSuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionTaiSui());
    }

    public NineStar getNineStar() {
        int index = LunarYear.fromYear(this.year).getZhiIndex() % 3;
        int m = Math.abs(this.month);
        int monthZhiIndex = (13 + m) % 12;
        int n = 27 - index * 3;
        if (monthZhiIndex < 2) {
            n -= 3;
        }
        int offset = (n - monthZhiIndex) % 9;
        return NineStar.fromIndex(offset);
    }

    public String toString() {
        return this.year + "\u5e74" + (this.isLeap() ? "\u95f0" : "") + LunarUtil.MONTH[Math.abs(this.month)] + "\u6708(" + this.dayCount + "\u5929)";
    }

    public LunarMonth next(int n) {
        int ny;
        if (0 == n) {
            return LunarMonth.fromYm(this.year, this.month);
        }
        if (n > 0) {
            int ny2;
            int rest = n;
            int iy = ny2 = this.year;
            int im = this.month;
            int index = 0;
            List<LunarMonth> months = LunarYear.fromYear(ny2).getMonths();
            while (true) {
                int more;
                int size = months.size();
                for (int i = 0; i < size; ++i) {
                    LunarMonth m = months.get(i);
                    if (m.getYear() != iy || m.getMonth() != im) continue;
                    index = i;
                    break;
                }
                if (rest < (more = size - index - 1)) break;
                rest -= more;
                LunarMonth lastMonth = months.get(size - 1);
                iy = lastMonth.getYear();
                im = lastMonth.getMonth();
                months = LunarYear.fromYear(++ny2).getMonths();
            }
            return months.get(index + rest);
        }
        int rest = -n;
        int iy = ny = this.year;
        int im = this.month;
        int index = 0;
        List<LunarMonth> months = LunarYear.fromYear(ny).getMonths();
        while (true) {
            int size = months.size();
            for (int i = 0; i < size; ++i) {
                LunarMonth m = months.get(i);
                if (m.getYear() != iy || m.getMonth() != im) continue;
                index = i;
                break;
            }
            if (rest <= index) break;
            rest -= index;
            LunarMonth firstMonth = months.get(0);
            iy = firstMonth.getYear();
            im = firstMonth.getMonth();
            months = LunarYear.fromYear(--ny).getMonths();
        }
        return months.get(index - rest);
    }
}

