/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.model;

import cn.authing.sdk.java.enums.AuthMethodEnum;
import cn.authing.sdk.java.enums.ProtocolEnum;
import cn.authing.sdk.java.model.AuthingClientOptions;
import cn.authing.sdk.java.util.HttpUtils;
import cn.hutool.core.util.StrUtil;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AuthenticationClientOptions
extends AuthingClientOptions {
    private String webSocketHost = "wss://openevent.authing.cn";
    private String webSocketEndpoint = "/events/v1/authentication/sub";
    private String appId;
    private String appSecret;
    private String appHost;
    private String redirectUri;
    private String logoutRedirectUri;
    private String scope = "openid profile offline_access";
    private String cookieKey;
    private int timeout = 10000;
    private String tokenEndPointAuthMethod = AuthMethodEnum.CLIENT_SECRET_POST.getValue();
    private String protocol = ProtocolEnum.OIDC.getValue();
    private String introspectionEndPointAuthMethod = AuthMethodEnum.CLIENT_SECRET_POST.getValue();
    private String revocationEndPointAuthMethod = AuthMethodEnum.CLIENT_SECRET_POST.getValue();
    private String AccessToken;

    public String getWebSocketHost() {
        return this.webSocketHost;
    }

    public void setWebSocketHost(String webSocketHost) {
        this.webSocketHost = webSocketHost;
    }

    public String getWebSocketEndpoint() {
        return this.webSocketEndpoint;
    }

    public void setWebSocketEndpoint(String webSocketEndpoint) {
        this.webSocketEndpoint = webSocketEndpoint;
    }

    @Override
    public String doRequest(String url, String method, Map<String, String> headers, Object body) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("x-authing-request-from", "java-sdk");
        headers.put("x-authing-sdk-version", "1.0.0");
        headers.put("x-authing-app-id", this.appId);
        String[] endpointsToSendBasicHeader = new String[]{"/oidc/token", "/oidc/token/revocation", "/oidc/token/introspection", "/oauth/token", "/oauth/token/revocation", "/oauth/token/introspection", "/api/v3/signin", "/api/v3/signin-by-mobile", "/api/v3/exchange-tokenset-with-qrcode-ticket"};
        if (Arrays.asList(endpointsToSendBasicHeader).contains(url)) {
            if (Objects.equals(this.getTokenEndPointAuthMethod(), AuthMethodEnum.CLIENT_SECRET_BASIC.getValue())) {
                headers.put("authorization", "Basic " + Base64.getEncoder().encodeToString((this.getAppId() + ":" + this.getAppSecret()).getBytes()));
            }
        } else if (StrUtil.isNotBlank((CharSequence)this.getAccessToken())) {
            headers.put("authorization", "Bearer " + this.getAccessToken());
        }
        return HttpUtils.request(this.getAppHost() + url, method, body, headers, this.getTimeout());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAppHost() {
        return this.appHost;
    }

    public void setAppHost(String appHost) {
        this.appHost = appHost;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getLogoutRedirectUri() {
        return this.logoutRedirectUri;
    }

    public void setLogoutRedirectUri(String logoutRedirectUri) {
        this.logoutRedirectUri = logoutRedirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTokenEndPointAuthMethod() {
        return this.tokenEndPointAuthMethod;
    }

    public void setTokenEndPointAuthMethod(String tokenEndPointAuthMethod) {
        this.tokenEndPointAuthMethod = tokenEndPointAuthMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIntrospectionEndPointAuthMethod() {
        return this.introspectionEndPointAuthMethod;
    }

    public void setIntrospectionEndPointAuthMethod(String introspectionEndPointAuthMethod) {
        this.introspectionEndPointAuthMethod = introspectionEndPointAuthMethod;
    }

    public String getAccessToken() {
        return this.AccessToken;
    }

    public void setAccessToken(String accessToken) {
        this.AccessToken = accessToken;
    }

    public String getRevocationEndPointAuthMethod() {
        return this.revocationEndPointAuthMethod;
    }

    public void setRevocationEndPointAuthMethod(String revocationEndPointAuthMethod) {
        this.revocationEndPointAuthMethod = revocationEndPointAuthMethod;
    }
}

