/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.model;

import cn.authing.sdk.java.enums.LanguageEnum;
import cn.authing.sdk.java.enums.SignatureEnum;
import cn.authing.sdk.java.model.AuthingClientOptions;
import cn.authing.sdk.java.util.CommonUtils;
import cn.authing.sdk.java.util.HttpUtils;
import cn.authing.sdk.java.util.JsonUtils;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Method;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ManagementClientOptions
extends AuthingClientOptions {
    private String websocketHost = "wss://openevent.authing.cn";
    private String websocketEndpoint = "/events/v1/management/sub";
    private String accessKeyId;
    private String accessKeySecret;
    private String tenantId;
    private int timeout = 10000;
    private LanguageEnum lang = LanguageEnum.CHINESE;
    private String host = "https://core.authing.cn";
    private Map<String, String> headers = new HashMap<String, String>();
    private static final int RANDOM_STRING_LENGTH = 16;
    private final ManagementTokenProvider tokenProvider = new ManagementTokenProvider(this);

    public String getWebsocketHost() {
        return this.websocketHost;
    }

    public void setWebsocketHost(String websocketHost) {
        this.websocketHost = websocketHost;
    }

    public String getWebsocketEndpoint() {
        return this.websocketEndpoint;
    }

    public void setWebsocketEndpoint(String websocketEndpoint) {
        this.websocketEndpoint = websocketEndpoint;
    }

    @Override
    public String doRequest(String url, String method, Map<String, String> headers, Object body) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("x-authing-lang", this.getLang().getValue());
        headers.put("x-authing-sdk-version", "authing-java-sdk:3.1.4");
        headers.put("x-authing-signature-method", SignatureEnum.X_AUTHING_SIGNATURE_METHOD.getValue());
        headers.put("x-authing-signature-nonce", CommonUtils.createRandomString(16));
        headers.put("x-authing-signature-version", SignatureEnum.X_AUTHING_SIGNATURE_VERSION.getValue());
        String tenantId = this.getTenantId();
        if (tenantId != null && !tenantId.trim().isEmpty()) {
            headers.put("x-authing-tenant-id", tenantId);
        }
        headers.put("date", String.valueOf(new Date().getTime()));
        headers.put("Authorization", this.tokenProvider.getAccessToken());
        headers.put("x-authing-userpool-id", this.tokenProvider.getUserPoolId());
        if (CollectionUtil.isNotEmpty(this.getHeaders())) {
            headers.putAll(this.getHeaders());
        }
        return HttpUtils.request(this.getHost() + url, method, body, headers, this.getTimeout());
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public LanguageEnum getLang() {
        return this.lang;
    }

    public void setLang(LanguageEnum lang) {
        this.lang = lang;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static class ManagementTokenProvider {
        private final ManagementClientOptions options;
        private String accessToken;
        private long accessTokenExpiredAt = 0L;
        private String userPoolId;

        public ManagementTokenProvider(ManagementClientOptions options) {
            this.options = options;
        }

        public String getAccessToken() {
            this.checkLoginStatus();
            return this.accessToken;
        }

        public String getUserPoolId() {
            this.checkLoginStatus();
            return this.userPoolId;
        }

        private void checkLoginStatus() {
            if (StrUtil.isNotBlank((CharSequence)this.accessToken) && this.accessTokenExpiredAt > System.currentTimeMillis() / 1000L) {
                return;
            }
            this.refreshManagementToken();
        }

        private void refreshManagementToken() {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("accessKeyId", this.options.getAccessKeyId());
            body.put("accessKeySecret", this.options.getAccessKeySecret());
            String response = HttpUtils.request(this.options.getHost() + "/api/v3/get-management-token", Method.POST.name(), body, null, this.options.getTimeout());
            LoginResponse loginResponse = JsonUtils.deserialize(response, LoginResponse.class);
            if (loginResponse == null) {
                throw new IllegalStateException("response is null");
            }
            if (loginResponse.statusCode != 200) {
                throw new RuntimeException(loginResponse.getMessage());
            }
            this.accessToken = loginResponse.getData().getAccess_token();
            this.accessTokenExpiredAt = System.currentTimeMillis() / 1000L + loginResponse.getData().getExpires_in();
            DecodedJWT decode = JWT.decode((String)this.accessToken);
            this.userPoolId = decode.getClaim("scoped_userpool_id").asString();
        }

        public static class LoginResponse {
            private Integer statusCode;
            private String message;
            private Data data;

            public Integer getStatusCode() {
                return this.statusCode;
            }

            public void setStatusCode(Integer statusCode) {
                this.statusCode = statusCode;
            }

            public String getMessage() {
                return this.message;
            }

            public void setMessage(String message) {
                this.message = message;
            }

            public Data getData() {
                return this.data;
            }

            public void setData(Data data) {
                this.data = data;
            }

            public static class Data {
                private String access_token;
                private Long expires_in;

                public String getAccess_token() {
                    return this.access_token;
                }

                public void setAccess_token(String access_token) {
                    this.access_token = access_token;
                }

                public Long getExpires_in() {
                    return this.expires_in;
                }

                public void setExpires_in(Long expires_in) {
                    this.expires_in = expires_in;
                }
            }
        }
    }
}

