/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.util;

import cn.authing.sdk.java.util.JsonUtils;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.util.Map;
import java.util.Set;

public class HttpUtils {
    private static final Log log = LogFactory.get((String)"[Authing]");

    public static String request(String url, String method, Object body, Map<String, String> headers, int timeout) {
        long start = System.currentTimeMillis();
        HttpResponse httpResponse = null;
        switch (method) {
            case "GET": {
                url = HttpUtils.buildUrlWithQueryParams(url, JsonUtils.deserialize(JsonUtils.serialize(body), Map.class));
                log.debug("\u8bf7\u6c42 url\uff1a {}", new Object[]{url});
                httpResponse = ((HttpRequest)HttpUtil.createRequest((Method)Method.valueOf((String)method), (String)url).setReadTimeout(timeout).setConnectionTimeout(timeout).headerMap(headers, true)).execute();
                break;
            }
            case "POST": {
                String bodyString = JsonUtils.serialize(body);
                log.debug("\u8bf7\u6c42 url\uff1a{}, body: {}", new Object[]{url, bodyString});
                httpResponse = ((HttpRequest)HttpUtil.createRequest((Method)Method.valueOf((String)method), (String)url).setReadTimeout(timeout).body(bodyString).setConnectionTimeout(timeout).headerMap(headers, true)).execute();
                break;
            }
            case "UrlencodedPOST": {
                String urlencodedBodyString = HttpUtils.buildQueryParams(JsonUtils.deserialize(JsonUtils.serialize(body), Map.class));
                log.debug("\u8bf7\u6c42 url\uff1a{}, body: {}", new Object[]{url, urlencodedBodyString});
                httpResponse = ((HttpRequest)HttpUtil.createRequest((Method)Method.valueOf((String)"POST"), (String)url).setReadTimeout(timeout).body(urlencodedBodyString).setConnectionTimeout(timeout).headerMap(headers, true)).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (httpResponse.isOk()) {
            String response = httpResponse.body();
            log.debug("\u54cd\u5e94\uff1a{}, \u8017\u65f6\uff1a{} ms", new Object[]{response, System.currentTimeMillis() - start});
            return response;
        }
        throw new RuntimeException(httpResponse.body());
    }

    public static String buildUrlWithQueryParams(String url, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder(url);
        if (params != null && !params.isEmpty()) {
            sb.append("?");
            sb.append(HttpUtils.buildQueryParams(params));
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String buildQueryParams(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Set<Map.Entry<String, Object>> entries = params.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                if (entry.getValue() == null) continue;
                sb.append(entry.getKey()).append("=").append(entry.getValue().toString()).append("&");
            }
        }
        return sb.toString();
    }
}

