/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T deserialize(String content, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serialize(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

