/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.builder;

import cn.idev.excel.ExcelWriter;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.write.builder.AbstractExcelWriterParameterBuilder;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteWorkbook;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public class CsvWriterBuilder
extends AbstractExcelWriterParameterBuilder<CsvWriterBuilder, WriteSheet> {
    private WriteWorkbook writeWorkbook;
    private CSVFormat.Builder csvFormatBuilder;
    private WriteSheet writeSheet;

    private CsvWriterBuilder() {
    }

    public CsvWriterBuilder(WriteWorkbook writeWorkbook) {
        writeWorkbook.setExcelType(ExcelTypeEnum.CSV);
        this.writeWorkbook = writeWorkbook;
        this.writeSheet = new WriteSheet();
        this.csvFormatBuilder = CSVFormat.DEFAULT.builder();
    }

    public CsvWriterBuilder delimiter(String delimiter) {
        if (delimiter != null) {
            this.csvFormatBuilder.setDelimiter(delimiter);
        }
        return this;
    }

    public CsvWriterBuilder quote(Character quote) {
        return this.quote(quote, QuoteMode.MINIMAL);
    }

    public CsvWriterBuilder quote(Character quote, QuoteMode quoteMode) {
        if (quote != null) {
            this.csvFormatBuilder.setQuote(quote);
        }
        if (quoteMode != null) {
            this.csvFormatBuilder.setQuoteMode(quoteMode);
        }
        return this;
    }

    public CsvWriterBuilder recordSeparator(String recordSeparator) {
        if (recordSeparator != null) {
            this.csvFormatBuilder.setRecordSeparator(recordSeparator);
        }
        return this;
    }

    public CsvWriterBuilder nullString(String nullString) {
        if (nullString != null) {
            this.csvFormatBuilder.setNullString(nullString);
        }
        return this;
    }

    public CsvWriterBuilder escape(Character escape) {
        if (escape != null) {
            this.csvFormatBuilder.setEscape(escape);
        }
        return this;
    }

    private ExcelWriter buildExcelWriter() {
        if (this.writeWorkbook.getAutoTrim() != null) {
            this.csvFormatBuilder.setTrim(this.writeWorkbook.getAutoTrim().booleanValue());
        }
        if (this.writeWorkbook.getNeedHead() != null) {
            this.csvFormatBuilder.setSkipHeaderRecord(this.writeWorkbook.getNeedHead() == false);
        }
        this.writeWorkbook.setCsvFormat(this.csvFormatBuilder.build());
        return new ExcelWriter(this.writeWorkbook);
    }

    public void doWrite(Collection<?> data) {
        if (this.writeWorkbook == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.write().csv()' to call this method");
        }
        ExcelWriter excelWriter = this.buildExcelWriter();
        excelWriter.write(data, this.writeSheet);
        excelWriter.finish();
    }

    public void doWrite(Supplier<Collection<?>> supplier) {
        this.doWrite(supplier.get());
    }

    @Override
    protected WriteSheet parameter() {
        return this.writeSheet;
    }
}

