/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LengthTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final int max;
    private final int min;
    public static final JsonpDeserializer<LengthTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LengthTokenFilter::setupLengthTokenFilterDeserializer);

    private LengthTokenFilter(Builder builder) {
        super(builder);
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
    }

    public static LengthTokenFilter of(Function<Builder, ObjectBuilder<LengthTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Length;
    }

    public final int max() {
        return this.max;
    }

    public final int min() {
        return this.min;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "length");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    protected static void setupLengthTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LengthTokenFilter> {
        private Integer max;
        private Integer min;

        public final Builder max(int value) {
            this.max = value;
            return this;
        }

        public final Builder min(int value) {
            this.min = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LengthTokenFilter build() {
            this._checkSingleUse();
            return new LengthTokenFilter(this);
        }
    }
}

