/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class LimitTokenCountTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final boolean consumeAllTokens;
    private final int maxTokenCount;
    public static final JsonpDeserializer<LimitTokenCountTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LimitTokenCountTokenFilter::setupLimitTokenCountTokenFilterDeserializer);

    private LimitTokenCountTokenFilter(Builder builder) {
        super(builder);
        this.consumeAllTokens = ApiTypeHelper.requireNonNull(builder.consumeAllTokens, this, "consumeAllTokens");
        this.maxTokenCount = ApiTypeHelper.requireNonNull(builder.maxTokenCount, this, "maxTokenCount");
    }

    public static LimitTokenCountTokenFilter of(Function<Builder, ObjectBuilder<LimitTokenCountTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Limit;
    }

    public final boolean consumeAllTokens() {
        return this.consumeAllTokens;
    }

    public final int maxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "limit");
        super.serializeInternal(generator, mapper);
        generator.writeKey("consume_all_tokens");
        generator.write(this.consumeAllTokens);
        generator.writeKey("max_token_count");
        generator.write(this.maxTokenCount);
    }

    protected static void setupLimitTokenCountTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::consumeAllTokens, JsonpDeserializer.booleanDeserializer(), "consume_all_tokens");
        op.add(Builder::maxTokenCount, JsonpDeserializer.integerDeserializer(), "max_token_count");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LimitTokenCountTokenFilter> {
        private Boolean consumeAllTokens;
        private Integer maxTokenCount;

        public final Builder consumeAllTokens(boolean value) {
            this.consumeAllTokens = value;
            return this;
        }

        public final Builder maxTokenCount(int value) {
            this.maxTokenCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LimitTokenCountTokenFilter build() {
            this._checkSingleUse();
            return new LimitTokenCountTokenFilter(this);
        }
    }
}

