/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExplainAnalyzeToken
implements JsonpSerializable {
    private final String bytes;
    private final long endOffset;
    @Nullable
    private final Boolean keyword;
    private final long position;
    private final long positionlength;
    private final long startOffset;
    private final long termfrequency;
    private final String token;
    private final String type;
    public static final JsonpDeserializer<ExplainAnalyzeToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainAnalyzeToken::setupExplainAnalyzeTokenDeserializer);

    private ExplainAnalyzeToken(Builder builder) {
        this.bytes = ApiTypeHelper.requireNonNull(builder.bytes, this, "bytes");
        this.endOffset = ApiTypeHelper.requireNonNull(builder.endOffset, this, "endOffset");
        this.keyword = builder.keyword;
        this.position = ApiTypeHelper.requireNonNull(builder.position, this, "position");
        this.positionlength = ApiTypeHelper.requireNonNull(builder.positionlength, this, "positionlength");
        this.startOffset = ApiTypeHelper.requireNonNull(builder.startOffset, this, "startOffset");
        this.termfrequency = ApiTypeHelper.requireNonNull(builder.termfrequency, this, "termfrequency");
        this.token = ApiTypeHelper.requireNonNull(builder.token, this, "token");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ExplainAnalyzeToken of(Function<Builder, ObjectBuilder<ExplainAnalyzeToken>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bytes() {
        return this.bytes;
    }

    public final long endOffset() {
        return this.endOffset;
    }

    @Nullable
    public final Boolean keyword() {
        return this.keyword;
    }

    public final long position() {
        return this.position;
    }

    public final long positionlength() {
        return this.positionlength;
    }

    public final long startOffset() {
        return this.startOffset;
    }

    public final long termfrequency() {
        return this.termfrequency;
    }

    public final String token() {
        return this.token;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bytes");
        generator.write(this.bytes);
        generator.writeKey("end_offset");
        generator.write(this.endOffset);
        if (this.keyword != null) {
            generator.writeKey("keyword");
            generator.write(this.keyword.booleanValue());
        }
        generator.writeKey("position");
        generator.write(this.position);
        generator.writeKey("positionLength");
        generator.write(this.positionlength);
        generator.writeKey("start_offset");
        generator.write(this.startOffset);
        generator.writeKey("termFrequency");
        generator.write(this.termfrequency);
        generator.writeKey("token");
        generator.write(this.token);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupExplainAnalyzeTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bytes, JsonpDeserializer.stringDeserializer(), "bytes");
        op.add(Builder::endOffset, JsonpDeserializer.longDeserializer(), "end_offset");
        op.add(Builder::keyword, JsonpDeserializer.booleanDeserializer(), "keyword");
        op.add(Builder::position, JsonpDeserializer.longDeserializer(), "position");
        op.add(Builder::positionlength, JsonpDeserializer.longDeserializer(), "positionLength");
        op.add(Builder::startOffset, JsonpDeserializer.longDeserializer(), "start_offset");
        op.add(Builder::termfrequency, JsonpDeserializer.longDeserializer(), "termFrequency");
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExplainAnalyzeToken> {
        private String bytes;
        private Long endOffset;
        @Nullable
        private Boolean keyword;
        private Long position;
        private Long positionlength;
        private Long startOffset;
        private Long termfrequency;
        private String token;
        private String type;

        public final Builder bytes(String value) {
            this.bytes = value;
            return this;
        }

        public final Builder endOffset(long value) {
            this.endOffset = value;
            return this;
        }

        public final Builder keyword(@Nullable Boolean value) {
            this.keyword = value;
            return this;
        }

        public final Builder position(long value) {
            this.position = value;
            return this;
        }

        public final Builder positionlength(long value) {
            this.positionlength = value;
            return this;
        }

        public final Builder startOffset(long value) {
            this.startOffset = value;
            return this;
        }

        public final Builder termfrequency(long value) {
            this.termfrequency = value;
            return this;
        }

        public final Builder token(String value) {
            this.token = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExplainAnalyzeToken build() {
            this._checkSingleUse();
            return new ExplainAnalyzeToken(this);
        }
    }
}

