/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_mapping;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexMappingRecord
implements JsonpSerializable {
    @Nullable
    private final TypeMapping item;
    private final TypeMapping mappings;
    public static final JsonpDeserializer<IndexMappingRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexMappingRecord::setupIndexMappingRecordDeserializer);

    private IndexMappingRecord(Builder builder) {
        this.item = builder.item;
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
    }

    public static IndexMappingRecord of(Function<Builder, ObjectBuilder<IndexMappingRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TypeMapping item() {
        return this.item;
    }

    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.item != null) {
            generator.writeKey("item");
            this.item.serialize(generator, mapper);
        }
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
    }

    protected static void setupIndexMappingRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::item, TypeMapping._DESERIALIZER, "item");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexMappingRecord> {
        @Nullable
        private TypeMapping item;
        private TypeMapping mappings;

        public final Builder item(@Nullable TypeMapping value) {
            this.item = value;
            return this;
        }

        public final Builder item(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.item(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexMappingRecord build() {
            this._checkSingleUse();
            return new IndexMappingRecord(this);
        }
    }
}

