/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RecoveryBytes
implements JsonpSerializable {
    private final String percent;
    @Nullable
    private final String recovered;
    private final String recoveredInBytes;
    @Nullable
    private final String recoveredFromSnapshot;
    @Nullable
    private final String recoveredFromSnapshotInBytes;
    @Nullable
    private final String reused;
    private final String reusedInBytes;
    @Nullable
    private final String total;
    private final String totalInBytes;
    public static final JsonpDeserializer<RecoveryBytes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryBytes::setupRecoveryBytesDeserializer);

    private RecoveryBytes(Builder builder) {
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = builder.recovered;
        this.recoveredInBytes = ApiTypeHelper.requireNonNull(builder.recoveredInBytes, this, "recoveredInBytes");
        this.recoveredFromSnapshot = builder.recoveredFromSnapshot;
        this.recoveredFromSnapshotInBytes = builder.recoveredFromSnapshotInBytes;
        this.reused = builder.reused;
        this.reusedInBytes = ApiTypeHelper.requireNonNull(builder.reusedInBytes, this, "reusedInBytes");
        this.total = builder.total;
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
    }

    public static RecoveryBytes of(Function<Builder, ObjectBuilder<RecoveryBytes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String percent() {
        return this.percent;
    }

    @Nullable
    public final String recovered() {
        return this.recovered;
    }

    public final String recoveredInBytes() {
        return this.recoveredInBytes;
    }

    @Nullable
    public final String recoveredFromSnapshot() {
        return this.recoveredFromSnapshot;
    }

    @Nullable
    public final String recoveredFromSnapshotInBytes() {
        return this.recoveredFromSnapshotInBytes;
    }

    @Nullable
    public final String reused() {
        return this.reused;
    }

    public final String reusedInBytes() {
        return this.reusedInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    public final String totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        if (this.recovered != null) {
            generator.writeKey("recovered");
            generator.write(this.recovered);
        }
        generator.writeKey("recovered_in_bytes");
        generator.write(this.recoveredInBytes);
        if (this.recoveredFromSnapshot != null) {
            generator.writeKey("recovered_from_snapshot");
            generator.write(this.recoveredFromSnapshot);
        }
        if (this.recoveredFromSnapshotInBytes != null) {
            generator.writeKey("recovered_from_snapshot_in_bytes");
            generator.write(this.recoveredFromSnapshotInBytes);
        }
        if (this.reused != null) {
            generator.writeKey("reused");
            generator.write(this.reused);
        }
        generator.writeKey("reused_in_bytes");
        generator.write(this.reusedInBytes);
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupRecoveryBytesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.stringDeserializer(), "recovered");
        op.add(Builder::recoveredInBytes, JsonpDeserializer.stringDeserializer(), "recovered_in_bytes");
        op.add(Builder::recoveredFromSnapshot, JsonpDeserializer.stringDeserializer(), "recovered_from_snapshot");
        op.add(Builder::recoveredFromSnapshotInBytes, JsonpDeserializer.stringDeserializer(), "recovered_from_snapshot_in_bytes");
        op.add(Builder::reused, JsonpDeserializer.stringDeserializer(), "reused");
        op.add(Builder::reusedInBytes, JsonpDeserializer.stringDeserializer(), "reused_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.stringDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryBytes> {
        private String percent;
        @Nullable
        private String recovered;
        private String recoveredInBytes;
        @Nullable
        private String recoveredFromSnapshot;
        @Nullable
        private String recoveredFromSnapshotInBytes;
        @Nullable
        private String reused;
        private String reusedInBytes;
        @Nullable
        private String total;
        private String totalInBytes;

        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        public final Builder recovered(@Nullable String value) {
            this.recovered = value;
            return this;
        }

        public final Builder recoveredInBytes(String value) {
            this.recoveredInBytes = value;
            return this;
        }

        public final Builder recoveredFromSnapshot(@Nullable String value) {
            this.recoveredFromSnapshot = value;
            return this;
        }

        public final Builder recoveredFromSnapshotInBytes(@Nullable String value) {
            this.recoveredFromSnapshotInBytes = value;
            return this;
        }

        public final Builder reused(@Nullable String value) {
            this.reused = value;
            return this;
        }

        public final Builder reusedInBytes(String value) {
            this.reusedInBytes = value;
            return this;
        }

        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(String value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryBytes build() {
            this._checkSingleUse();
            return new RecoveryBytes(this);
        }
    }
}

