/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration;

import co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status.MigrationFeature;
import co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status.MigrationStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetFeatureUpgradeStatusResponse
implements JsonpSerializable {
    private final List<MigrationFeature> features;
    private final MigrationStatus migrationStatus;
    public static final JsonpDeserializer<GetFeatureUpgradeStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetFeatureUpgradeStatusResponse::setupGetFeatureUpgradeStatusResponseDeserializer);

    private GetFeatureUpgradeStatusResponse(Builder builder) {
        this.features = ApiTypeHelper.unmodifiableRequired(builder.features, (Object)this, "features");
        this.migrationStatus = ApiTypeHelper.requireNonNull(builder.migrationStatus, this, "migrationStatus");
    }

    public static GetFeatureUpgradeStatusResponse of(Function<Builder, ObjectBuilder<GetFeatureUpgradeStatusResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<MigrationFeature> features() {
        return this.features;
    }

    public final MigrationStatus migrationStatus() {
        return this.migrationStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.features)) {
            generator.writeKey("features");
            generator.writeStartArray();
            for (MigrationFeature item0 : this.features) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("migration_status");
        this.migrationStatus.serialize(generator, mapper);
    }

    protected static void setupGetFeatureUpgradeStatusResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::features, JsonpDeserializer.arrayDeserializer(MigrationFeature._DESERIALIZER), "features");
        op.add(Builder::migrationStatus, MigrationStatus._DESERIALIZER, "migration_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetFeatureUpgradeStatusResponse> {
        private List<MigrationFeature> features;
        private MigrationStatus migrationStatus;

        public final Builder features(List<MigrationFeature> list) {
            this.features = Builder._listAddAll(this.features, list);
            return this;
        }

        public final Builder features(MigrationFeature value, MigrationFeature ... values) {
            this.features = Builder._listAdd(this.features, value, values);
            return this;
        }

        public final Builder features(Function<MigrationFeature.Builder, ObjectBuilder<MigrationFeature>> fn) {
            return this.features(fn.apply(new MigrationFeature.Builder()).build(), new MigrationFeature[0]);
        }

        public final Builder migrationStatus(MigrationStatus value) {
            this.migrationStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetFeatureUpgradeStatusResponse build() {
            this._checkSingleUse();
            return new GetFeatureUpgradeStatusResponse(this);
        }
    }
}

