/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.NodeAttributes;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStats;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsDataCounts;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsMemoryUsage;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsProgress;
import co.elastic.clients.elasticsearch.ml.DataframeState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalytics
implements JsonpSerializable {
    @Nullable
    private final DataframeAnalyticsStats analysisStats;
    @Nullable
    private final String assignmentExplanation;
    private final DataframeAnalyticsStatsDataCounts dataCounts;
    private final String id;
    private final DataframeAnalyticsStatsMemoryUsage memoryUsage;
    @Nullable
    private final NodeAttributes node;
    private final List<DataframeAnalyticsStatsProgress> progress;
    private final DataframeState state;
    public static final JsonpDeserializer<DataframeAnalytics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalytics::setupDataframeAnalyticsDeserializer);

    private DataframeAnalytics(Builder builder) {
        this.analysisStats = builder.analysisStats;
        this.assignmentExplanation = builder.assignmentExplanation;
        this.dataCounts = ApiTypeHelper.requireNonNull(builder.dataCounts, this, "dataCounts");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.memoryUsage = ApiTypeHelper.requireNonNull(builder.memoryUsage, this, "memoryUsage");
        this.node = builder.node;
        this.progress = ApiTypeHelper.unmodifiableRequired(builder.progress, (Object)this, "progress");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static DataframeAnalytics of(Function<Builder, ObjectBuilder<DataframeAnalytics>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataframeAnalyticsStats analysisStats() {
        return this.analysisStats;
    }

    @Nullable
    public final String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public final DataframeAnalyticsStatsDataCounts dataCounts() {
        return this.dataCounts;
    }

    public final String id() {
        return this.id;
    }

    public final DataframeAnalyticsStatsMemoryUsage memoryUsage() {
        return this.memoryUsage;
    }

    @Nullable
    public final NodeAttributes node() {
        return this.node;
    }

    public final List<DataframeAnalyticsStatsProgress> progress() {
        return this.progress;
    }

    public final DataframeState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysisStats != null) {
            generator.writeKey("analysis_stats");
            this.analysisStats.serialize(generator, mapper);
        }
        if (this.assignmentExplanation != null) {
            generator.writeKey("assignment_explanation");
            generator.write(this.assignmentExplanation);
        }
        generator.writeKey("data_counts");
        this.dataCounts.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("memory_usage");
        this.memoryUsage.serialize(generator, mapper);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.progress)) {
            generator.writeKey("progress");
            generator.writeStartArray();
            for (DataframeAnalyticsStatsProgress item0 : this.progress) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    protected static void setupDataframeAnalyticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analysisStats, DataframeAnalyticsStats._DESERIALIZER, "analysis_stats");
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation");
        op.add(Builder::dataCounts, DataframeAnalyticsStatsDataCounts._DESERIALIZER, "data_counts");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::memoryUsage, DataframeAnalyticsStatsMemoryUsage._DESERIALIZER, "memory_usage");
        op.add(Builder::node, NodeAttributes._DESERIALIZER, "node");
        op.add(Builder::progress, JsonpDeserializer.arrayDeserializer(DataframeAnalyticsStatsProgress._DESERIALIZER), "progress");
        op.add(Builder::state, DataframeState._DESERIALIZER, "state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalytics> {
        @Nullable
        private DataframeAnalyticsStats analysisStats;
        @Nullable
        private String assignmentExplanation;
        private DataframeAnalyticsStatsDataCounts dataCounts;
        private String id;
        private DataframeAnalyticsStatsMemoryUsage memoryUsage;
        @Nullable
        private NodeAttributes node;
        private List<DataframeAnalyticsStatsProgress> progress;
        private DataframeState state;

        public final Builder analysisStats(@Nullable DataframeAnalyticsStats value) {
            this.analysisStats = value;
            return this;
        }

        public final Builder analysisStats(Function<DataframeAnalyticsStats.Builder, ObjectBuilder<DataframeAnalyticsStats>> fn) {
            return this.analysisStats(fn.apply(new DataframeAnalyticsStats.Builder()).build());
        }

        public final Builder assignmentExplanation(@Nullable String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public final Builder dataCounts(DataframeAnalyticsStatsDataCounts value) {
            this.dataCounts = value;
            return this;
        }

        public final Builder dataCounts(Function<DataframeAnalyticsStatsDataCounts.Builder, ObjectBuilder<DataframeAnalyticsStatsDataCounts>> fn) {
            return this.dataCounts(fn.apply(new DataframeAnalyticsStatsDataCounts.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder memoryUsage(DataframeAnalyticsStatsMemoryUsage value) {
            this.memoryUsage = value;
            return this;
        }

        public final Builder memoryUsage(Function<DataframeAnalyticsStatsMemoryUsage.Builder, ObjectBuilder<DataframeAnalyticsStatsMemoryUsage>> fn) {
            return this.memoryUsage(fn.apply(new DataframeAnalyticsStatsMemoryUsage.Builder()).build());
        }

        public final Builder node(@Nullable NodeAttributes value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.node(fn.apply(new NodeAttributes.Builder()).build());
        }

        public final Builder progress(List<DataframeAnalyticsStatsProgress> list) {
            this.progress = Builder._listAddAll(this.progress, list);
            return this;
        }

        public final Builder progress(DataframeAnalyticsStatsProgress value, DataframeAnalyticsStatsProgress ... values) {
            this.progress = Builder._listAdd(this.progress, value, values);
            return this;
        }

        public final Builder progress(Function<DataframeAnalyticsStatsProgress.Builder, ObjectBuilder<DataframeAnalyticsStatsProgress>> fn) {
            return this.progress(fn.apply(new DataframeAnalyticsStatsProgress.Builder()).build(), new DataframeAnalyticsStatsProgress[0]);
        }

        public final Builder state(DataframeState value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalytics build() {
            this._checkSingleUse();
            return new DataframeAnalytics(this);
        }
    }
}

