/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Filter;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetFiltersResponse
implements JsonpSerializable {
    private final long count;
    private final List<Filter> filters;
    public static final JsonpDeserializer<GetFiltersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetFiltersResponse::setupGetFiltersResponseDeserializer);

    private GetFiltersResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.filters = ApiTypeHelper.unmodifiableRequired(builder.filters, (Object)this, "filters");
    }

    public static GetFiltersResponse of(Function<Builder, ObjectBuilder<GetFiltersResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.filters)) {
            generator.writeKey("filters");
            generator.writeStartArray();
            for (Filter item0 : this.filters) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetFiltersResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(Filter._DESERIALIZER), "filters");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetFiltersResponse> {
        private Long count;
        private List<Filter> filters;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder filters(List<Filter> list) {
            this.filters = Builder._listAddAll(this.filters, list);
            return this;
        }

        public final Builder filters(Filter value, Filter ... values) {
            this.filters = Builder._listAdd(this.filters, value, values);
            return this;
        }

        public final Builder filters(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filters(fn.apply(new Filter.Builder()).build(), new Filter[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetFiltersResponse build() {
            this._checkSingleUse();
            return new GetFiltersResponse(this);
        }
    }
}

